/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.builder;

import soot.AnySubType;
import soot.ArrayType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.toolkits.scalar.Pair;

public class GlobalNodeFactory {
    protected final RefType rtObject;
    protected final RefType rtClassLoader;
    protected final RefType rtString;
    protected final RefType rtThread;
    protected final RefType rtThreadGroup;
    protected final RefType rtThrowable;
    protected PAG pag;

    public GlobalNodeFactory(PAG pag) {
        this.pag = pag;
        this.rtObject = RefType.v("java.lang.Object");
        this.rtClassLoader = RefType.v("java.lang.ClassLoader");
        this.rtString = RefType.v("java.lang.String");
        this.rtThread = RefType.v("java.lang.Thread");
        this.rtThreadGroup = RefType.v("java.lang.ThreadGroup");
        this.rtThrowable = RefType.v("java.lang.Throwable");
    }

    public final Node caseDefaultClassLoader() {
        AllocNode a = this.pag.makeAllocNode("DEFAULT_CLASS_LOADER", AnySubType.v(this.rtClassLoader), null);
        GlobalVarNode v = this.pag.makeGlobalVarNode("DEFAULT_CLASS_LOADER_LOCAL", this.rtClassLoader);
        this.pag.addEdge(a, v);
        return v;
    }

    public final Node caseMainClassNameString() {
        AllocNode a = this.pag.makeAllocNode("MAIN_CLASS_NAME_STRING", this.rtString, null);
        GlobalVarNode v = this.pag.makeGlobalVarNode("MAIN_CLASS_NAME_STRING_LOCAL", this.rtString);
        this.pag.addEdge(a, v);
        return v;
    }

    public final Node caseMainThreadGroup() {
        AllocNode threadGroupNode = this.pag.makeAllocNode("MAIN_THREAD_GROUP_NODE", this.rtThreadGroup, null);
        GlobalVarNode threadGroupNodeLocal = this.pag.makeGlobalVarNode("MAIN_THREAD_GROUP_NODE_LOCAL", this.rtThreadGroup);
        this.pag.addEdge(threadGroupNode, threadGroupNodeLocal);
        return threadGroupNodeLocal;
    }

    public final Node casePrivilegedActionException() {
        AllocNode a = this.pag.makeAllocNode("PRIVILEGED_ACTION_EXCEPTION", AnySubType.v(RefType.v("java.security.PrivilegedActionException")), null);
        GlobalVarNode v = this.pag.makeGlobalVarNode("PRIVILEGED_ACTION_EXCEPTION_LOCAL", RefType.v("java.security.PrivilegedActionException"));
        this.pag.addEdge(a, v);
        return v;
    }

    public final Node caseCanonicalPath() {
        AllocNode a = this.pag.makeAllocNode("CANONICAL_PATH", this.rtString, null);
        GlobalVarNode v = this.pag.makeGlobalVarNode("CANONICAL_PATH_LOCAL", this.rtString);
        this.pag.addEdge(a, v);
        return v;
    }

    public final Node caseMainThread() {
        AllocNode threadNode = this.pag.makeAllocNode("MAIN_THREAD_NODE", this.rtThread, null);
        GlobalVarNode threadNodeLocal = this.pag.makeGlobalVarNode("MAIN_THREAD_NODE_LOCAL", this.rtThread);
        this.pag.addEdge(threadNode, threadNodeLocal);
        return threadNodeLocal;
    }

    public final Node caseFinalizeQueue() {
        return this.pag.makeGlobalVarNode("FINALIZE_QUEUE", this.rtObject);
    }

    public final Node caseArgv() {
        ArrayType strArray = ArrayType.v(this.rtString, 1);
        AllocNode argv = this.pag.makeAllocNode("STRING_ARRAY_NODE", strArray, null);
        GlobalVarNode sanl = this.pag.makeGlobalVarNode("STRING_ARRAY_NODE_LOCAL", strArray);
        AllocNode stringNode = this.pag.makeAllocNode("STRING_NODE", this.rtString, null);
        GlobalVarNode stringNodeLocal = this.pag.makeGlobalVarNode("STRING_NODE_LOCAL", this.rtString);
        this.pag.addEdge(argv, sanl);
        this.pag.addEdge(stringNode, stringNodeLocal);
        this.pag.addEdge(stringNodeLocal, this.pag.makeFieldRefNode(sanl, ArrayElement.v()));
        return sanl;
    }

    public final Node caseNewInstance(VarNode cls) {
        if (cls instanceof ContextVarNode) {
            cls = this.pag.findLocalVarNode(cls.getVariable());
        }
        GlobalVarNode local = this.pag.makeGlobalVarNode(cls, this.rtObject);
        for (SootClass cl : Scene.v().dynamicClasses()) {
            AllocNode site = this.pag.makeAllocNode(new Pair<VarNode, SootClass>(cls, cl), cl.getType(), null);
            this.pag.addEdge(site, local);
        }
        return local;
    }

    public Node caseThrow() {
        GlobalVarNode ret = this.pag.makeGlobalVarNode("EXCEPTION_NODE", this.rtThrowable);
        ret.setInterProcTarget();
        ret.setInterProcSource();
        return ret;
    }
}

