/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import soot.EquivalentValue;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Expr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.Stmt;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayFlowUniverse;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.Chain;
import soot.util.HashChain;

public class SlowAvailableExpressionsAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<Value>> {
    protected final Map<Unit, BoundedFlowSet<Value>> unitToGenerateSet;
    protected final Map<Unit, BoundedFlowSet<Value>> unitToPreserveSet;
    protected final Map<Value, Stmt> rhsToContainingStmt;
    protected final FlowSet<Value> emptySet;
    private final HashMap<Value, EquivalentValue> valueToEquivValue = new HashMap();

    public SlowAvailableExpressionsAnalysis(DirectedGraph<Unit> dg) {
        super(dg);
        this.rhsToContainingStmt = new HashMap<Value, Stmt>();
        HashSet<Value> exprs = new HashSet<Value>();
        HashMap<EquivalentValue, HashChain<Object>> containingExprs = new HashMap<EquivalentValue, HashChain<Object>>();
        HashMap equivValToSiblingList = new HashMap();
        UnitGraph g = (UnitGraph)dg;
        for (Unit u : g.getBody().getUnits()) {
            Chain<Value> sibList;
            Unit s = (Stmt)u;
            if (!(s instanceof AssignStmt)) continue;
            Value v = ((AssignStmt)s).getRightOp();
            this.rhsToContainingStmt.put(v, (Stmt)s);
            Object ev = this.valueToEquivValue.get(v);
            if (ev == null) {
                ev = new EquivalentValue(v);
                this.valueToEquivValue.put(v, (EquivalentValue)ev);
            }
            if ((sibList = (HashChain<Value>)equivValToSiblingList.get(ev)) == null) {
                sibList = new HashChain<Value>();
                equivValToSiblingList.put((EquivalentValue)ev, sibList);
            }
            if (!sibList.contains(v)) {
                sibList.add(v);
            }
            if (!(v instanceof Expr) || exprs.contains(v)) continue;
            exprs.add(v);
            for (ValueBox vb : v.getUseBoxes()) {
                HashChain<Object> l;
                Value o = vb.getValue();
                EquivalentValue eo = this.valueToEquivValue.get(o);
                if (eo == null) {
                    eo = new EquivalentValue(o);
                    this.valueToEquivValue.put(o, eo);
                }
                if ((sibList = (Chain)equivValToSiblingList.get(eo)) == null) {
                    sibList = new HashChain();
                    equivValToSiblingList.put(eo, sibList);
                }
                if (!sibList.contains(o)) {
                    sibList.add(o);
                }
                if ((l = (HashChain<Object>)containingExprs.get(eo)) == null) {
                    l = new HashChain<Object>();
                    containingExprs.put(eo, l);
                }
                if (l.contains(ev)) continue;
                l.add(ev);
            }
        }
        ArrayFlowUniverse<Value> exprUniv = new ArrayFlowUniverse<Value>(exprs.toArray(new Value[exprs.size()]));
        this.emptySet = new ArrayPackedSet<Value>(exprUniv);
        this.unitToPreserveSet = new HashMap<Unit, BoundedFlowSet<Value>>(g.size() * 2 + 1, 0.7f);
        for (Unit s : g) {
            ArrayPackedSet<Value> killSet = new ArrayPackedSet<Value>(exprUniv);
            for (ValueBox box : s.getDefBoxes()) {
                Chain c = (Chain)containingExprs.get(this.valueToEquivValue.get(box.getValue()));
                if (c == null) continue;
                for (EquivalentValue container2 : c) {
                    for (Value sibVal : (Chain)equivValToSiblingList.get(container2)) {
                        killSet.add(sibVal);
                    }
                }
            }
            killSet.complement(killSet);
            this.unitToPreserveSet.put(s, killSet);
        }
        this.unitToGenerateSet = new HashMap<Unit, BoundedFlowSet<Value>>(g.size() * 2 + 1, 0.7f);
        for (Unit s : g) {
            AssignStmt as;
            Value gen;
            ArrayPackedSet<Value> genSet = new ArrayPackedSet<Value>(exprUniv);
            if (s instanceof AssignStmt && (gen = (as = (AssignStmt)s).getRightOp()) instanceof Expr && !(gen instanceof NewExpr) && !(gen instanceof NewArrayExpr) && !(gen instanceof NewMultiArrayExpr) && !(gen instanceof InvokeExpr)) {
                genSet.add(gen);
            }
            genSet.intersection((FlowSet<Value>)this.unitToPreserveSet.get(s), genSet);
            this.unitToGenerateSet.put(s, genSet);
        }
        this.doAnalysis();
    }

    @Override
    protected FlowSet<Value> newInitialFlow() {
        BoundedFlowSet out = (BoundedFlowSet)this.emptySet.clone();
        out.complement(out);
        return out;
    }

    @Override
    protected FlowSet<Value> entryInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void flowThrough(FlowSet<Value> in, Unit unit, FlowSet<Value> out) {
        in.intersection((FlowSet<Value>)this.unitToPreserveSet.get(unit), out);
        out.union((FlowSet<Value>)this.unitToGenerateSet.get(unit));
    }

    @Override
    protected void merge(FlowSet<Value> inSet1, FlowSet<Value> inSet2, FlowSet<Value> outSet) {
        inSet1.intersection(inSet2, outSet);
    }

    @Override
    protected void copy(FlowSet<Value> sourceSet, FlowSet<Value> destSet) {
        sourceSet.copy(destSet);
    }
}

