/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LocalGenerator;
import soot.LongType;
import soot.NullType;
import soot.RefType;
import soot.Scene;
import soot.SootMethodRef;
import soot.TrapManager;
import soot.Type;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.ConcreteRef;
import soot.jimple.ConditionExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.Expr;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.RemExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.jimple.toolkits.typing.ClassHierarchy;
import soot.jimple.toolkits.typing.InternalTypingException;
import soot.jimple.toolkits.typing.TypeException;
import soot.jimple.toolkits.typing.TypeNode;
import soot.jimple.toolkits.typing.TypeResolver;
import soot.jimple.toolkits.typing.Util;

class ConstraintChecker
extends AbstractStmtSwitch {
    private static final Logger logger = LoggerFactory.getLogger(ConstraintChecker.class);
    private final ClassHierarchy hierarchy;
    private final boolean fix;
    private JimpleBody stmtBody;
    private LocalGenerator localGenerator;

    public ConstraintChecker(TypeResolver resolver, boolean fix) {
        this.fix = fix;
        this.hierarchy = resolver.hierarchy();
    }

    public void check(Stmt stmt, JimpleBody stmtBody) throws TypeException {
        try {
            this.stmtBody = stmtBody;
            this.localGenerator = Scene.v().createLocalGenerator(stmtBody);
            stmt.apply(this);
        }
        catch (RuntimeTypeException e) {
            logger.error(e.getMessage(), e);
            throw new TypeException(e.getMessage(), e);
        }
    }

    static void error(String message) {
        throw new RuntimeTypeException(message);
    }

    private void handleInvokeExpr(InvokeExpr ie, Stmt invokestmt) {
        RefType classType;
        Value base;
        Local local;
        SootMethodRef method = ie.getMethodRef();
        for (int i = 0; i < ie.getArgCount(); ++i) {
            Value arg = ie.getArg(i);
            if (!(arg instanceof Local)) continue;
            local = (Local)arg;
            Type parameterType = method.getParameterType(i);
            if (this.hierarchy.typeNode(local.getType()).hasAncestorOrSelf(this.hierarchy.typeNode(parameterType))) continue;
            if (this.fix) {
                ie.setArg(i, this.insertCast(local, parameterType, invokestmt));
                continue;
            }
            ConstraintChecker.error("Type Error");
        }
        if (ie instanceof InterfaceInvokeExpr) {
            InterfaceInvokeExpr invoke = (InterfaceInvokeExpr)ie;
            base = invoke.getBase();
            if (base instanceof Local) {
                local = (Local)base;
                classType = method.getDeclaringClass().getType();
                if (!this.hierarchy.typeNode(local.getType()).hasAncestorOrSelf(this.hierarchy.typeNode(classType))) {
                    if (this.fix) {
                        invoke.setBase(this.insertCast(local, classType, invokestmt));
                    } else {
                        ConstraintChecker.error("Type Error(7): local " + local + " is of incompatible type " + local.getType());
                    }
                }
            }
        } else if (ie instanceof SpecialInvokeExpr) {
            SpecialInvokeExpr invoke = (SpecialInvokeExpr)ie;
            base = invoke.getBase();
            if (base instanceof Local) {
                local = (Local)base;
                classType = method.getDeclaringClass().getType();
                if (!this.hierarchy.typeNode(local.getType()).hasAncestorOrSelf(this.hierarchy.typeNode(classType))) {
                    if (this.fix) {
                        invoke.setBase(this.insertCast(local, classType, invokestmt));
                    } else {
                        ConstraintChecker.error("Type Error(9)");
                    }
                }
            }
        } else if (ie instanceof VirtualInvokeExpr) {
            VirtualInvokeExpr invoke = (VirtualInvokeExpr)ie;
            base = invoke.getBase();
            if (base instanceof Local) {
                local = (Local)base;
                classType = method.getDeclaringClass().getType();
                if (!this.hierarchy.typeNode(local.getType()).hasAncestorOrSelf(this.hierarchy.typeNode(classType))) {
                    if (this.fix) {
                        invoke.setBase(this.insertCast(local, classType, invokestmt));
                    } else {
                        ConstraintChecker.error("Type Error(13)");
                    }
                }
            }
        } else if (!(ie instanceof StaticInvokeExpr)) {
            if (ie instanceof DynamicInvokeExpr) {
                DynamicInvokeExpr die = (DynamicInvokeExpr)ie;
                SootMethodRef bootstrapMethod = die.getMethodRef();
                for (int i = 0; i < die.getBootstrapArgCount(); ++i) {
                    if (!(die.getBootstrapArg(i) instanceof Local)) continue;
                    Local local2 = (Local)die.getBootstrapArg(i);
                    Type parameterType = bootstrapMethod.getParameterType(i);
                    if (this.hierarchy.typeNode(local2.getType()).hasAncestorOrSelf(this.hierarchy.typeNode(parameterType))) continue;
                    if (this.fix) {
                        ie.setArg(i, this.insertCast(local2, parameterType, invokestmt));
                        continue;
                    }
                    ConstraintChecker.error("Type Error");
                }
            } else {
                throw new RuntimeException("Unhandled invoke expression type: " + ie.getClass());
            }
        }
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    @Override
    public void caseInvokeStmt(InvokeStmt stmt) {
        this.handleInvokeExpr(stmt.getInvokeExpr(), stmt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        Expr ne;
        Object op;
        RefType classTy;
        Object base;
        ConcreteRef ref;
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        TypeNode left = null;
        if (l instanceof ArrayRef) {
            ref = (ArrayRef)l;
            base = this.hierarchy.typeNode(((Local)ref.getBase()).getType());
            if (!((TypeNode)base).isArray()) {
                ConstraintChecker.error("Type Error(16)");
            }
            left = ((TypeNode)base).element();
            Value index = ref.getIndex();
            if (index instanceof Local && !this.hierarchy.typeNode(((Local)index).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) {
                ConstraintChecker.error("Type Error(17)");
            }
        } else if (l instanceof Local) {
            try {
                left = this.hierarchy.typeNode(((Local)l).getType());
            }
            catch (InternalTypingException e) {
                logger.debug("untyped local: " + l);
                throw e;
            }
        } else if (l instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)l;
            base = (Local)ref.getBase();
            classTy = ref.getField().getDeclaringClass().getType();
            if (!this.hierarchy.typeNode(base.getType()).hasAncestorOrSelf(this.hierarchy.typeNode(classTy))) {
                if (this.fix) {
                    ref.setBase(this.insertCast((Local)base, classTy, stmt));
                } else {
                    ConstraintChecker.error("Type Error(18)");
                }
            }
            left = this.hierarchy.typeNode(ref.getField().getType());
        } else {
            if (!(l instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment left hand side type: " + l.getClass());
            ref = (StaticFieldRef)l;
            left = this.hierarchy.typeNode(((StaticFieldRef)ref).getField().getType());
        }
        if (r instanceof ArrayRef) {
            Value index;
            ref = (ArrayRef)r;
            base = (Local)ref.getBase();
            TypeNode baseTy = this.hierarchy.typeNode(base.getType());
            if (!baseTy.isArray()) {
                ConstraintChecker.error("Type Error(19): " + baseTy + " is not an array type");
            }
            if (baseTy == this.hierarchy.NULL) {
                return;
            }
            if (!left.hasDescendantOrSelf(baseTy.element())) {
                if (this.fix) {
                    Type lefttype = left.type();
                    if (lefttype instanceof ArrayType) {
                        ArrayType atype = (ArrayType)lefttype;
                        ref.setBase(this.insertCast((Local)base, ArrayType.v(atype.baseType, atype.numDimensions + 1), stmt));
                    } else {
                        ref.setBase(this.insertCast((Local)base, ArrayType.v(lefttype, 1), stmt));
                    }
                } else {
                    ConstraintChecker.error("Type Error(20)");
                }
            }
            if (!((index = ref.getIndex()) instanceof Local) || this.hierarchy.typeNode(((Local)index).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintChecker.error("Type Error(21)");
            return;
        }
        if (r instanceof DoubleConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(DoubleType.v()))) return;
            ConstraintChecker.error("Type Error(22)");
            return;
        }
        if (r instanceof FloatConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(FloatType.v()))) return;
            ConstraintChecker.error("Type Error(45)");
            return;
        }
        if (r instanceof IntConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintChecker.error("Type Error(23)");
            return;
        }
        if (r instanceof LongConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(LongType.v()))) return;
            ConstraintChecker.error("Type Error(24)");
            return;
        }
        if (r instanceof NullConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(NullType.v()))) return;
            ConstraintChecker.error("Type Error(25)");
            return;
        }
        if (r instanceof StringConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.String")))) return;
            ConstraintChecker.error("Type Error(26)");
            return;
        }
        if (r instanceof ClassConstant) {
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Class")))) return;
            ConstraintChecker.error("Type Error(27)");
            return;
        }
        if (r instanceof BinopExpr) {
            TypeNode rop;
            TypeNode lop;
            BinopExpr be = (BinopExpr)r;
            Value lv = be.getOp1();
            Value rv = be.getOp2();
            if (lv instanceof Local) {
                lop = this.hierarchy.typeNode(((Local)lv).getType());
            } else if (lv instanceof DoubleConstant) {
                lop = this.hierarchy.typeNode(DoubleType.v());
            } else if (lv instanceof FloatConstant) {
                lop = this.hierarchy.typeNode(FloatType.v());
            } else if (lv instanceof IntConstant) {
                lop = this.hierarchy.typeNode(IntType.v());
            } else if (lv instanceof LongConstant) {
                lop = this.hierarchy.typeNode(LongType.v());
            } else if (lv instanceof NullConstant) {
                lop = this.hierarchy.typeNode(NullType.v());
            } else if (lv instanceof StringConstant) {
                lop = this.hierarchy.typeNode(RefType.v("java.lang.String"));
            } else {
                if (!(lv instanceof ClassConstant)) throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
                lop = this.hierarchy.typeNode(RefType.v("java.lang.Class"));
            }
            if (rv instanceof Local) {
                rop = this.hierarchy.typeNode(((Local)rv).getType());
            } else if (rv instanceof DoubleConstant) {
                rop = this.hierarchy.typeNode(DoubleType.v());
            } else if (rv instanceof FloatConstant) {
                rop = this.hierarchy.typeNode(FloatType.v());
            } else if (rv instanceof IntConstant) {
                rop = this.hierarchy.typeNode(IntType.v());
            } else if (rv instanceof LongConstant) {
                rop = this.hierarchy.typeNode(LongType.v());
            } else if (rv instanceof NullConstant) {
                rop = this.hierarchy.typeNode(NullType.v());
            } else if (rv instanceof StringConstant) {
                rop = this.hierarchy.typeNode(RefType.v("java.lang.String"));
            } else {
                if (!(rv instanceof ClassConstant)) throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
                rop = this.hierarchy.typeNode(RefType.v("java.lang.Class"));
            }
            if (be instanceof AddExpr || be instanceof SubExpr || be instanceof MulExpr || be instanceof DivExpr || be instanceof RemExpr || be instanceof AndExpr || be instanceof OrExpr || be instanceof XorExpr) {
                if (left.hasDescendantOrSelf(lop) && left.hasDescendantOrSelf(rop)) return;
                ConstraintChecker.error("Type Error(27)");
                return;
            }
            if (be instanceof ShlExpr || be instanceof ShrExpr || be instanceof UshrExpr) {
                if (left.hasDescendantOrSelf(lop) && this.hierarchy.typeNode(IntType.v()).hasAncestorOrSelf(rop)) return;
                ConstraintChecker.error("Type Error(28)");
                return;
            }
            if (!(be instanceof CmpExpr) && !(be instanceof CmpgExpr) && !(be instanceof CmplExpr) && !(be instanceof EqExpr) && !(be instanceof GeExpr) && !(be instanceof GtExpr) && !(be instanceof LeExpr) && !(be instanceof LtExpr) && !(be instanceof NeExpr)) throw new RuntimeException("Unhandled binary expression type: " + be.getClass());
            try {
                lop.lca(rop);
            }
            catch (TypeException e) {
                ConstraintChecker.error(e.getMessage());
            }
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintChecker.error("Type Error(29)");
            return;
        }
        if (r instanceof CastExpr) {
            CastExpr ce = (CastExpr)r;
            TypeNode castTy = this.hierarchy.typeNode(ce.getCastType());
            op = ce.getOp();
            if (op instanceof Local) {
                TypeNode opTy = this.hierarchy.typeNode(((Local)op).getType());
                try {
                    if (castTy.isClassOrInterface() || opTy.isClassOrInterface()) {
                        castTy.lca(opTy);
                    }
                }
                catch (TypeException e) {
                    logger.debug(r + "[" + opTy + "<->" + castTy + "]");
                    ConstraintChecker.error(e.getMessage());
                }
            }
            if (left.hasDescendantOrSelf(castTy)) return;
            ConstraintChecker.error("Type Error(30)");
            return;
        }
        if (r instanceof InstanceOfExpr) {
            InstanceOfExpr ioe = (InstanceOfExpr)r;
            TypeNode type = this.hierarchy.typeNode(ioe.getCheckType());
            op = this.hierarchy.typeNode(ioe.getOp().getType());
            try {
                ((TypeNode)op).lca(type);
            }
            catch (TypeException e) {
                logger.debug(r + "[" + op + "<->" + type + "]");
                ConstraintChecker.error(e.getMessage());
            }
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintChecker.error("Type Error(31)");
            return;
        }
        if (r instanceof InvokeExpr) {
            InvokeExpr ie = (InvokeExpr)r;
            this.handleInvokeExpr(ie, stmt);
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(ie.getMethodRef().getReturnType()))) return;
            ConstraintChecker.error("Type Error(32)");
            return;
        } else if (r instanceof NewArrayExpr) {
            TypeNode var;
            Value size;
            NewArrayExpr nae = (NewArrayExpr)r;
            Type baseType = nae.getBaseType();
            TypeNode right = baseType instanceof ArrayType ? this.hierarchy.typeNode(ArrayType.v(((ArrayType)baseType).baseType, ((ArrayType)baseType).numDimensions + 1)) : this.hierarchy.typeNode(ArrayType.v(baseType, 1));
            if (!left.hasDescendantOrSelf(right)) {
                ConstraintChecker.error("Type Error(33)");
            }
            if (!((size = nae.getSize()) instanceof Local) || (var = this.hierarchy.typeNode(((Local)size).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) return;
            ConstraintChecker.error("Type Error(34)");
            return;
        } else if (r instanceof NewExpr) {
            ne = (NewExpr)r;
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(ne.getBaseType()))) return;
            ConstraintChecker.error("Type Error(35)");
            return;
        } else if (r instanceof NewMultiArrayExpr) {
            NewMultiArrayExpr nmae = (NewMultiArrayExpr)r;
            if (!left.hasDescendantOrSelf(this.hierarchy.typeNode(nmae.getBaseType()))) {
                ConstraintChecker.error("Type Error(36)");
            }
            for (int i = 0; i < nmae.getSizeCount(); ++i) {
                TypeNode var;
                Value size = nmae.getSize(i);
                if (!(size instanceof Local) || (var = this.hierarchy.typeNode(((Local)size).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) continue;
                ConstraintChecker.error("Type Error(37)");
            }
            return;
        } else if (r instanceof LengthExpr) {
            Value op2;
            LengthExpr le = (LengthExpr)r;
            if (!left.hasDescendantOrSelf(this.hierarchy.typeNode(IntType.v()))) {
                ConstraintChecker.error("Type Error(38)");
            }
            if (!((op2 = le.getOp()) instanceof Local) || this.hierarchy.typeNode(((Local)op2).getType()).isArray()) return;
            ConstraintChecker.error("Type Error(39)");
            return;
        } else if (r instanceof NegExpr) {
            TypeNode right;
            ne = (NegExpr)r;
            op = ne.getOp();
            if (op instanceof Local) {
                right = this.hierarchy.typeNode(((Local)op).getType());
            } else if (op instanceof DoubleConstant) {
                right = this.hierarchy.typeNode(DoubleType.v());
            } else if (op instanceof FloatConstant) {
                right = this.hierarchy.typeNode(FloatType.v());
            } else if (op instanceof IntConstant) {
                right = this.hierarchy.typeNode(IntType.v());
            } else {
                if (!(op instanceof LongConstant)) throw new RuntimeException("Unhandled neg expression operand type: " + op.getClass());
                right = this.hierarchy.typeNode(LongType.v());
            }
            if (left.hasDescendantOrSelf(right)) return;
            ConstraintChecker.error("Type Error(40)");
            return;
        } else if (r instanceof Local) {
            Local loc = (Local)r;
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(loc.getType()))) return;
            if (this.fix) {
                stmt.setRightOp(this.insertCast(loc, left.type(), stmt));
                return;
            } else {
                ConstraintChecker.error("Type Error(41)");
            }
            return;
        } else if (r instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)r;
            base = (Local)ref.getBase();
            classTy = ref.getField().getDeclaringClass().getType();
            if (!this.hierarchy.typeNode(base.getType()).hasAncestorOrSelf(this.hierarchy.typeNode(classTy))) {
                if (this.fix) {
                    ref.setBase(this.insertCast((Local)base, classTy, stmt));
                } else {
                    ConstraintChecker.error("Type Error(42)");
                }
            }
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(ref.getField().getType()))) return;
            ConstraintChecker.error("Type Error(43)");
            return;
        } else {
            if (!(r instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment right hand side type: " + r.getClass());
            ref = (StaticFieldRef)r;
            if (left.hasDescendantOrSelf(this.hierarchy.typeNode(((StaticFieldRef)ref).getField().getType()))) return;
            ConstraintChecker.error("Type Error(44)");
        }
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
        TypeNode left = this.hierarchy.typeNode(((Local)stmt.getLeftOp()).getType());
        Value r = stmt.getRightOp();
        if (r instanceof CaughtExceptionRef) {
            for (Type type : TrapManager.getExceptionTypesOf(stmt, this.stmtBody)) {
                if (left.hasDescendantOrSelf(this.hierarchy.typeNode(type))) continue;
                ConstraintChecker.error("Type Error(47)");
            }
            if (!left.hasAncestorOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Throwable")))) {
                ConstraintChecker.error("Type Error(48)");
            }
        } else {
            TypeNode right = this.hierarchy.typeNode(r.getType());
            if (!left.hasDescendantOrSelf(right)) {
                ConstraintChecker.error("Type Error(46) [" + left + " <- " + right + "]");
            }
        }
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        TypeNode opTy;
        Value op = stmt.getOp();
        if (op instanceof Local && !(opTy = this.hierarchy.typeNode(((Local)op).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Object")))) {
            ConstraintChecker.error("Type Error(49)");
        }
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        TypeNode opTy;
        Value op = stmt.getOp();
        if (op instanceof Local && !(opTy = this.hierarchy.typeNode(((Local)op).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Object")))) {
            ConstraintChecker.error("Type Error(49)");
        }
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        TypeNode rop;
        TypeNode lop;
        ConditionExpr expr = (ConditionExpr)stmt.getCondition();
        Value lv = expr.getOp1();
        Value rv = expr.getOp2();
        if (lv instanceof Local) {
            lop = this.hierarchy.typeNode(((Local)lv).getType());
        } else if (lv instanceof DoubleConstant) {
            lop = this.hierarchy.typeNode(DoubleType.v());
        } else if (lv instanceof FloatConstant) {
            lop = this.hierarchy.typeNode(FloatType.v());
        } else if (lv instanceof IntConstant) {
            lop = this.hierarchy.typeNode(IntType.v());
        } else if (lv instanceof LongConstant) {
            lop = this.hierarchy.typeNode(LongType.v());
        } else if (lv instanceof NullConstant) {
            lop = this.hierarchy.typeNode(NullType.v());
        } else if (lv instanceof StringConstant) {
            lop = this.hierarchy.typeNode(RefType.v("java.lang.String"));
        } else if (lv instanceof ClassConstant) {
            lop = this.hierarchy.typeNode(RefType.v("java.lang.Class"));
        } else {
            throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
        }
        if (rv instanceof Local) {
            rop = this.hierarchy.typeNode(((Local)rv).getType());
        } else if (rv instanceof DoubleConstant) {
            rop = this.hierarchy.typeNode(DoubleType.v());
        } else if (rv instanceof FloatConstant) {
            rop = this.hierarchy.typeNode(FloatType.v());
        } else if (rv instanceof IntConstant) {
            rop = this.hierarchy.typeNode(IntType.v());
        } else if (rv instanceof LongConstant) {
            rop = this.hierarchy.typeNode(LongType.v());
        } else if (rv instanceof NullConstant) {
            rop = this.hierarchy.typeNode(NullType.v());
        } else if (rv instanceof StringConstant) {
            rop = this.hierarchy.typeNode(RefType.v("java.lang.String"));
        } else if (rv instanceof ClassConstant) {
            rop = this.hierarchy.typeNode(RefType.v("java.lang.Class"));
        } else {
            throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
        }
        try {
            lop.lca(rop);
        }
        catch (TypeException e) {
            ConstraintChecker.error(e.getMessage());
        }
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        Value key = stmt.getKey();
        if (key instanceof Local && !this.hierarchy.typeNode(((Local)key).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) {
            ConstraintChecker.error("Type Error(50)");
        }
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        Value op = stmt.getOp();
        if (op instanceof Local) {
            Local opLocal = (Local)op;
            Type returnType = this.stmtBody.getMethod().getReturnType();
            if (!this.hierarchy.typeNode(opLocal.getType()).hasAncestorOrSelf(this.hierarchy.typeNode(returnType))) {
                if (this.fix) {
                    stmt.setOp(this.insertCast(opLocal, returnType, stmt));
                } else {
                    ConstraintChecker.error("Type Error(51)");
                }
            }
        }
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        Value key = stmt.getKey();
        if (key instanceof Local && !this.hierarchy.typeNode(((Local)key).getType()).hasAncestorOrSelf(this.hierarchy.typeNode(IntType.v()))) {
            ConstraintChecker.error("Type Error(52)");
        }
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
        Local opLocal;
        TypeNode opTy;
        Value op = stmt.getOp();
        if (op instanceof Local && !(opTy = this.hierarchy.typeNode((opLocal = (Local)op).getType())).hasAncestorOrSelf(this.hierarchy.typeNode(RefType.v("java.lang.Throwable")))) {
            if (this.fix) {
                stmt.setOp(this.insertCast(opLocal, RefType.v("java.lang.Throwable"), stmt));
            } else {
                ConstraintChecker.error("Type Error(53)");
            }
        }
    }

    public void defaultCase(Stmt stmt) {
        throw new RuntimeException("Unhandled statement type: " + stmt.getClass());
    }

    private Local insertCast(Local oldlocal, Type type, Stmt stmt) {
        Jimple jimp = Jimple.v();
        Local newlocal = this.localGenerator.generateLocal(type);
        this.stmtBody.getUnits().insertBefore(jimp.newAssignStmt(newlocal, jimp.newCastExpr(oldlocal, type)), Util.findFirstNonIdentityUnit(this.stmtBody, stmt));
        return newlocal;
    }

    private static class RuntimeTypeException
    extends RuntimeException {
        RuntimeTypeException(String message) {
            super(message);
        }
    }
}

