/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.shimple.toolkits.scalar.SEvaluator;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardBranchedFlowAnalysis;
import soot.toolkits.scalar.Pair;

class SCPFAnalysis
extends ForwardBranchedFlowAnalysis<FlowSet<Object>> {
    protected static final ArraySparseSet<Object> EMPTY_SET = new ArraySparseSet();
    protected final Map<Local, Constant> localToConstant;
    protected final Map<Stmt, GotoStmt> stmtToReplacement = new HashMap<Stmt, GotoStmt>();
    protected final List<IfStmt> deadStmts = new ArrayList<IfStmt>();

    public SCPFAnalysis(UnitGraph graph) {
        super(graph);
        Map<Local, Constant> ref = this.localToConstant = new HashMap<Local, Constant>(graph.size() * 2 + 1, 0.7f);
        for (Local local : graph.getBody().getLocals()) {
            ref.put(local, SEvaluator.TopConstant.v());
        }
        this.doAnalysis();
    }

    public Map<Local, Constant> getResults() {
        return this.localToConstant;
    }

    public List<IfStmt> getDeadStmts() {
        return this.deadStmts;
    }

    public Map<Stmt, GotoStmt> getStmtsToReplace() {
        return this.stmtToReplacement;
    }

    @Override
    protected boolean treatTrapHandlersAsEntries() {
        return true;
    }

    @Override
    protected FlowSet<Object> entryInitialFlow() {
        FlowSet<Object> entrySet = EMPTY_SET.emptySet();
        entrySet.add(SEvaluator.TopConstant.v());
        return entrySet;
    }

    @Override
    protected FlowSet<Object> newInitialFlow() {
        return EMPTY_SET.emptySet();
    }

    @Override
    protected void merge(FlowSet<Object> in1, FlowSet<Object> in2, FlowSet<Object> out) {
        in1.union(in2, out);
    }

    @Override
    protected void copy(FlowSet<Object> source, FlowSet<Object> dest) {
        source.copy(dest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void flowThrough(FlowSet<Object> in, Unit s, List<FlowSet<Object>> fallOut, List<FlowSet<Object>> branchOuts) {
        UnitBox branchBox;
        int index;
        Constant keyC;
        if (in.isEmpty()) {
            return;
        }
        FlowSet<Object> fin = in.clone();
        Pair<Unit, Constant> pair = this.processDefinitionStmt(s);
        if (pair != null) {
            fin.add(pair);
        }
        if (!s.branches() && s.fallsThrough()) {
            for (FlowSet<Object> fallSet : fallOut) {
                fallSet.union(fin);
            }
            return;
        }
        boolean conservative = true;
        boolean fall = false;
        boolean branch = false;
        FlowSet<Object> oneBranch = null;
        if (s instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)s;
            Constant constant = SEvaluator.getFuzzyConstantValueOf(ifStmt.getCondition(), this.localToConstant);
            if (constant instanceof SEvaluator.TopConstant) {
                return;
            }
            if (constant instanceof SEvaluator.BottomConstant) {
                this.deadStmts.remove(ifStmt);
                this.stmtToReplacement.remove(ifStmt);
            } else {
                conservative = false;
                if (IntConstant.v(0).equals(constant)) {
                    fall = true;
                    this.deadStmts.add(ifStmt);
                } else {
                    if (!IntConstant.v(1).equals(constant)) throw new RuntimeException("IfStmt condition must be 0 or 1! Found: " + constant);
                    branch = true;
                    this.stmtToReplacement.put(ifStmt, Jimple.v().newGotoStmt(ifStmt.getTargetBox()));
                }
            }
        } else if (s instanceof TableSwitchStmt) {
            TableSwitchStmt table = (TableSwitchStmt)s;
            keyC = SEvaluator.getFuzzyConstantValueOf(table.getKey(), this.localToConstant);
            if (keyC instanceof SEvaluator.TopConstant) {
                return;
            }
            if (keyC instanceof SEvaluator.BottomConstant) {
                this.stmtToReplacement.remove(table);
            } else if (keyC instanceof IntConstant) {
                conservative = false;
                index = ((IntConstant)keyC).value - table.getLowIndex();
                branchBox = index < 0 || index > table.getHighIndex() ? table.getDefaultTargetBox() : table.getTargetBox(index);
                this.stmtToReplacement.put(table, Jimple.v().newGotoStmt(branchBox));
                oneBranch = branchOuts.get(table.getUnitBoxes().indexOf(branchBox));
            }
        } else if (s instanceof LookupSwitchStmt) {
            LookupSwitchStmt lookup = (LookupSwitchStmt)s;
            keyC = SEvaluator.getFuzzyConstantValueOf(lookup.getKey(), this.localToConstant);
            if (keyC instanceof SEvaluator.TopConstant) {
                return;
            }
            if (keyC instanceof SEvaluator.BottomConstant) {
                this.stmtToReplacement.remove(lookup);
            } else if (keyC instanceof IntConstant) {
                conservative = false;
                index = lookup.getLookupValues().indexOf(keyC);
                branchBox = index < 0 ? lookup.getDefaultTargetBox() : lookup.getTargetBox(index);
                this.stmtToReplacement.put(lookup, Jimple.v().newGotoStmt(branchBox));
                oneBranch = branchOuts.get(lookup.getUnitBoxes().indexOf(branchBox));
            }
        }
        if (conservative) {
            fall = s.fallsThrough();
            branch = s.branches();
        }
        if (fall) {
            for (FlowSet<Object> fallSet : fallOut) {
                fallSet.union(fin);
            }
        }
        if (branch) {
            for (FlowSet<Object> branchSet : branchOuts) {
                branchSet.union(fin);
            }
        }
        if (oneBranch == null) return;
        oneBranch.union(fin);
    }

    protected Pair<Unit, Constant> processDefinitionStmt(Unit u) {
        Local local;
        DefinitionStmt dStmt;
        Value value;
        if (u instanceof DefinitionStmt && (value = (dStmt = (DefinitionStmt)u).getLeftOp()) instanceof Local && this.merge(local = (Local)value, SEvaluator.getFuzzyConstantValueOf(dStmt.getRightOp(), this.localToConstant))) {
            return new Pair<Unit, Constant>(u, this.localToConstant.get(local));
        }
        return null;
    }

    protected boolean merge(Local local, Constant constant) {
        Constant current = this.localToConstant.get(local);
        if (current instanceof SEvaluator.BottomConstant) {
            return false;
        }
        if (current instanceof SEvaluator.TopConstant) {
            this.localToConstant.put(local, constant);
            return true;
        }
        if (current.equals(constant)) {
            return false;
        }
        this.localToConstant.put(local, SEvaluator.BottomConstant.v());
        return true;
    }
}

