/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.scalar;

import java.util.Map;
import soot.Local;
import soot.Type;
import soot.UnitBoxOwner;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.Expr;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.shimple.PhiExpr;
import soot.util.Switch;

public class SEvaluator {
    public static boolean isValueConstantValued(Value op) {
        if (op instanceof PhiExpr) {
            Constant firstConstant = null;
            for (Value arg : ((PhiExpr)op).getValues()) {
                if (!(arg instanceof Constant)) {
                    return false;
                }
                if (firstConstant == null) {
                    firstConstant = (Constant)arg;
                    continue;
                }
                if (firstConstant.equals(arg)) continue;
                return false;
            }
            return true;
        }
        return Evaluator.isValueConstantValued(op);
    }

    public static Value getConstantValueOf(Value op) {
        if (op instanceof PhiExpr) {
            return SEvaluator.isValueConstantValued(op) ? ((PhiExpr)op).getValue(0) : null;
        }
        return Evaluator.getConstantValueOf(op);
    }

    public static Constant getFuzzyConstantValueOf(Value v) {
        if (v instanceof Constant) {
            return (Constant)v;
        }
        if (v instanceof Local) {
            return BottomConstant.v();
        }
        if (!(v instanceof Expr)) {
            return BottomConstant.v();
        }
        Constant constant = null;
        if (v instanceof PhiExpr) {
            PhiExpr phi = (PhiExpr)v;
            for (Value arg : phi.getValues()) {
                if (!(arg instanceof Constant) || arg instanceof TopConstant) continue;
                if (constant == null) {
                    constant = (Constant)arg;
                    continue;
                }
                if (constant.equals(arg)) continue;
                constant = BottomConstant.v();
                break;
            }
            if (constant == null) {
                constant = TopConstant.v();
            }
        } else {
            for (ValueBox name : v.getUseBoxes()) {
                Value value = name.getValue();
                if (value instanceof BottomConstant) {
                    constant = BottomConstant.v();
                    break;
                }
                if (!(value instanceof TopConstant)) continue;
                constant = TopConstant.v();
            }
            if (constant == null) {
                constant = (Constant)SEvaluator.getConstantValueOf(v);
            }
            if (constant == null) {
                constant = BottomConstant.v();
            }
        }
        return constant;
    }

    public static Constant getFuzzyConstantValueOf(Value v, Map<Local, Constant> localToConstant) {
        if (v instanceof Constant) {
            return (Constant)v;
        }
        if (v instanceof Local) {
            return localToConstant.get((Local)v);
        }
        if (!(v instanceof Expr)) {
            return BottomConstant.v();
        }
        Expr expr = (Expr)v.clone();
        for (ValueBox useBox : expr.getUseBoxes()) {
            Constant constant;
            Value use = useBox.getValue();
            if (!(use instanceof Local) || !useBox.canContainValue(constant = localToConstant.get((Local)use))) continue;
            useBox.setValue(constant);
        }
        if (expr instanceof UnitBoxOwner) {
            ((UnitBoxOwner)((Object)expr)).clearUnitBoxes();
        }
        return SEvaluator.getFuzzyConstantValueOf(expr);
    }

    public static class BottomConstant
    extends MetaConstant {
        private static final BottomConstant constant = new BottomConstant();

        private BottomConstant() {
        }

        public static Constant v() {
            return constant;
        }

        @Override
        public Type getType() {
            return UnknownType.v();
        }

        @Override
        public void apply(Switch sw) {
            throw new RuntimeException("Not implemented.");
        }
    }

    public static class TopConstant
    extends MetaConstant {
        private static final TopConstant constant = new TopConstant();

        private TopConstant() {
        }

        public static Constant v() {
            return constant;
        }

        @Override
        public Type getType() {
            return UnknownType.v();
        }

        @Override
        public void apply(Switch sw) {
            throw new RuntimeException("Not implemented.");
        }
    }

    public static abstract class MetaConstant
    extends Constant {
    }
}

