/*
 * Decompiled with CFR 0.152.
 */
package heros;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.FlowFunction;
import heros.FlowFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowFunctionCache<N, D, M>
implements FlowFunctions<N, D, M> {
    protected final FlowFunctions<N, D, M> delegate;
    protected final LoadingCache<NNKey, FlowFunction<D>> normalCache;
    protected final LoadingCache<CallKey, FlowFunction<D>> callCache;
    protected final LoadingCache<ReturnKey, FlowFunction<D>> returnCache;
    protected final LoadingCache<NNKey, FlowFunction<D>> callToReturnCache;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FlowFunctionCache(final FlowFunctions<N, D, M> delegate, CacheBuilder builder) {
        this.delegate = delegate;
        this.normalCache = builder.build(new CacheLoader<NNKey, FlowFunction<D>>(){

            @Override
            public FlowFunction<D> load(NNKey key) throws Exception {
                return delegate.getNormalFlowFunction(key.getCurr(), key.getSucc());
            }
        });
        this.callCache = builder.build(new CacheLoader<CallKey, FlowFunction<D>>(){

            @Override
            public FlowFunction<D> load(CallKey key) throws Exception {
                return delegate.getCallFlowFunction(key.getCallStmt(), key.getDestinationMethod());
            }
        });
        this.returnCache = builder.build(new CacheLoader<ReturnKey, FlowFunction<D>>(){

            @Override
            public FlowFunction<D> load(ReturnKey key) throws Exception {
                return delegate.getReturnFlowFunction(key.getCallStmt(), key.getDestinationMethod(), key.getExitStmt(), key.getReturnSite());
            }
        });
        this.callToReturnCache = builder.build(new CacheLoader<NNKey, FlowFunction<D>>(){

            @Override
            public FlowFunction<D> load(NNKey key) throws Exception {
                return delegate.getCallToReturnFlowFunction(key.getCurr(), key.getSucc());
            }
        });
    }

    @Override
    public FlowFunction<D> getNormalFlowFunction(N curr, N succ) {
        return this.normalCache.getUnchecked(new NNKey(curr, succ));
    }

    @Override
    public FlowFunction<D> getCallFlowFunction(N callStmt, M destinationMethod) {
        return this.callCache.getUnchecked(new CallKey(callStmt, destinationMethod));
    }

    @Override
    public FlowFunction<D> getReturnFlowFunction(N callSite, M calleeMethod, N exitStmt, N returnSite) {
        return this.returnCache.getUnchecked(new ReturnKey(callSite, calleeMethod, exitStmt, returnSite));
    }

    @Override
    public FlowFunction<D> getCallToReturnFlowFunction(N callSite, N returnSite) {
        return this.callToReturnCache.getUnchecked(new NNKey(callSite, returnSite));
    }

    public void printStats() {
        this.logger.debug("Stats for flow-function cache:\nNormal:         {}\nCall:           {}\nReturn:         {}\nCall-to-return: {}\n", this.normalCache.stats(), this.callCache.stats(), this.returnCache.stats(), this.callToReturnCache.stats());
    }

    public void invalidate() {
        this.callCache.invalidateAll();
        this.callToReturnCache.invalidateAll();
        this.normalCache.invalidateAll();
        this.returnCache.invalidateAll();
    }

    private class ReturnKey
    extends CallKey {
        private final N exitStmt;
        private final N returnSite;

        private ReturnKey(N callStmt, M destinationMethod, N exitStmt, N returnSite) {
            super(callStmt, destinationMethod);
            this.exitStmt = exitStmt;
            this.returnSite = returnSite;
        }

        public N getExitStmt() {
            return this.exitStmt;
        }

        public N getReturnSite() {
            return this.returnSite;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.exitStmt == null ? 0 : this.exitStmt.hashCode());
            result = 31 * result + (this.returnSite == null ? 0 : this.returnSite.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReturnKey other = (ReturnKey)obj;
            if (this.exitStmt == null ? other.exitStmt != null : !this.exitStmt.equals(other.exitStmt)) {
                return false;
            }
            return !(this.returnSite == null ? other.returnSite != null : !this.returnSite.equals(other.returnSite));
        }
    }

    private class CallKey {
        private final N callStmt;
        private final M destinationMethod;

        private CallKey(N callStmt, M destinationMethod) {
            this.callStmt = callStmt;
            this.destinationMethod = destinationMethod;
        }

        public N getCallStmt() {
            return this.callStmt;
        }

        public M getDestinationMethod() {
            return this.destinationMethod;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.callStmt == null ? 0 : this.callStmt.hashCode());
            result = 31 * result + (this.destinationMethod == null ? 0 : this.destinationMethod.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallKey other = (CallKey)obj;
            if (this.callStmt == null ? other.callStmt != null : !this.callStmt.equals(other.callStmt)) {
                return false;
            }
            return !(this.destinationMethod == null ? other.destinationMethod != null : !this.destinationMethod.equals(other.destinationMethod));
        }
    }

    private class NNKey {
        private final N curr;
        private final N succ;

        private NNKey(N curr, N succ) {
            this.curr = curr;
            this.succ = succ;
        }

        public N getCurr() {
            return this.curr;
        }

        public N getSucc() {
            return this.succ;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.curr == null ? 0 : this.curr.hashCode());
            result = 31 * result + (this.succ == null ? 0 : this.succ.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NNKey other = (NNKey)obj;
            if (this.curr == null ? other.curr != null : !this.curr.equals(other.curr)) {
                return false;
            }
            return !(this.succ == null ? other.succ != null : !this.succ.equals(other.succ));
        }
    }
}

