/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import com.google.common.collect.Lists;
import heros.fieldsens.AccessPath;
import heros.fieldsens.CallEdge;
import heros.fieldsens.Debugger;
import heros.fieldsens.PerAccessPathMethodAnalyzer;
import heros.fieldsens.ResolverTemplate;
import heros.fieldsens.structs.WrappedFactAtStatement;

class CallEdgeResolver<Field, Fact, Stmt, Method>
extends ResolverTemplate<Field, Fact, Stmt, Method, CallEdge<Field, Fact, Stmt, Method>> {
    public CallEdgeResolver(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Debugger<Field, Fact, Stmt, Method> debugger) {
        this(analyzer, debugger, null);
    }

    public CallEdgeResolver(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Debugger<Field, Fact, Stmt, Method> debugger, CallEdgeResolver<Field, Fact, Stmt, Method> parent) {
        super(analyzer, analyzer.getAccessPath(), parent, debugger);
    }

    @Override
    protected AccessPath<Field> getAccessPathOf(CallEdge<Field, Fact, Stmt, Method> inc) {
        return inc.getCalleeSourceFact().getAccessPath();
    }

    @Override
    protected void processIncomingGuaranteedPrefix(CallEdge<Field, Fact, Stmt, Method> inc) {
        this.analyzer.applySummaries(inc);
    }

    @Override
    protected void processIncomingPotentialPrefix(CallEdge<Field, Fact, Stmt, Method> inc) {
        this.lock();
        inc.registerInterestCallback(this.analyzer);
        this.unlock();
    }

    @Override
    protected ResolverTemplate<Field, Fact, Stmt, Method, CallEdge<Field, Fact, Stmt, Method>> createNestedResolver(AccessPath<Field> newAccPath) {
        return this.analyzer.createWithAccessPath(newAccPath).getCallEdgeResolver();
    }

    public void applySummaries(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
        for (CallEdge incEdge : Lists.newLinkedList(this.incomingEdges)) {
            this.analyzer.applySummary(incEdge, factAtStmt);
        }
    }

    public String toString() {
        return "<" + this.analyzer.getAccessPath() + ":" + this.analyzer.getMethod() + ">";
    }

    @Override
    protected void log(String message) {
        this.analyzer.log(message);
    }

    public boolean hasIncomingEdges() {
        return !this.incomingEdges.isEmpty();
    }
}

