/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import heros.fieldsens.FlowFunction;
import heros.fieldsens.InterestCallback;
import heros.fieldsens.PerAccessPathMethodAnalyzer;
import java.util.List;
import java.util.Set;

public abstract class Resolver<Field, Fact, Stmt, Method> {
    private Set<Resolver<Field, Fact, Stmt, Method>> interest = Sets.newHashSet();
    private List<InterestCallback<Field, Fact, Stmt, Method>> interestCallbacks = Lists.newLinkedList();
    protected PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer;
    private boolean canBeResolvedEmpty = false;

    public Resolver(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer) {
        this.analyzer = analyzer;
    }

    public abstract void resolve(FlowFunction.Constraint<Field> var1, InterestCallback<Field, Fact, Stmt, Method> var2);

    public void interest(Resolver<Field, Fact, Stmt, Method> resolver) {
        if (!this.interest.add(resolver)) {
            return;
        }
        this.log("Interest given by: " + resolver);
        for (InterestCallback interestCallback : Lists.newLinkedList(this.interestCallbacks)) {
            interestCallback.interest(this.analyzer, resolver);
        }
    }

    protected void canBeResolvedEmpty() {
        if (this.canBeResolvedEmpty) {
            return;
        }
        this.canBeResolvedEmpty = true;
        for (InterestCallback interestCallback : Lists.newLinkedList(this.interestCallbacks)) {
            interestCallback.canBeResolvedEmpty();
        }
    }

    public boolean isInterestGiven() {
        return !this.interest.isEmpty();
    }

    protected void registerCallback(InterestCallback<Field, Fact, Stmt, Method> callback) {
        if (!this.interest.isEmpty()) {
            for (Resolver resolver : Lists.newLinkedList(this.interest)) {
                callback.interest(this.analyzer, resolver);
            }
        }
        this.log("Callback registered");
        this.interestCallbacks.add(callback);
        if (this.canBeResolvedEmpty) {
            callback.canBeResolvedEmpty();
        }
    }

    protected abstract void log(String var1);
}

