/*
 * Decompiled with CFR 0.152.
 */
package heros.utilities;

import com.google.common.collect.Maps;
import heros.utilities.DefaultValueMap;
import heros.utilities.JsonArray;
import java.util.Map;

public class JsonDocument {
    private DefaultValueMap<String, JsonDocument> documents = new DefaultValueMap<String, JsonDocument>(){

        @Override
        protected JsonDocument createItem(String key) {
            return new JsonDocument();
        }
    };
    private DefaultValueMap<String, JsonArray> arrays = new DefaultValueMap<String, JsonArray>(){

        @Override
        protected JsonArray createItem(String key) {
            return new JsonArray();
        }
    };
    private Map<String, String> keyValuePairs = Maps.newHashMap();

    public JsonDocument doc(String key) {
        return this.documents.getOrCreate(key);
    }

    public JsonDocument doc(String key, JsonDocument doc) {
        if (this.documents.containsKey(key)) {
            throw new IllegalArgumentException("There is already a document registered for key: " + key);
        }
        this.documents.put(key, doc);
        return doc;
    }

    public JsonArray array(String key) {
        return this.arrays.getOrCreate(key);
    }

    public void keyValue(String key, String value) {
        this.keyValuePairs.put(key, value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.write(builder, 0);
        return builder.toString();
    }

    public void write(StringBuilder builder, int tabs) {
        builder.append("{\n");
        for (Map.Entry<String, String> entry : this.keyValuePairs.entrySet()) {
            JsonDocument.tabs(tabs + 1, builder);
            builder.append("\"" + entry.getKey() + "\": \"" + entry.getValue() + "\",\n");
        }
        for (Map.Entry<String, Object> entry : this.arrays.entrySet()) {
            JsonDocument.tabs(tabs + 1, builder);
            builder.append("\"" + entry.getKey() + "\": ");
            ((JsonArray)entry.getValue()).write(builder, tabs + 1);
            builder.append(",\n");
        }
        for (Map.Entry<String, Object> entry : this.documents.entrySet()) {
            JsonDocument.tabs(tabs + 1, builder);
            builder.append("\"" + entry.getKey() + "\": ");
            ((JsonDocument)entry.getValue()).write(builder, tabs + 1);
            builder.append(",\n");
        }
        if (!(this.keyValuePairs.isEmpty() && this.arrays.isEmpty() && this.documents.isEmpty())) {
            builder.delete(builder.length() - 2, builder.length() - 1);
        }
        JsonDocument.tabs(tabs, builder);
        builder.append("}");
    }

    static void tabs(int tabs, StringBuilder builder) {
        for (int i = 0; i < tabs; ++i) {
            builder.append("\t");
        }
    }
}

