/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emt4j.agent.common.jdkdependent.CallerInfo;
import org.eclipse.emt4j.common.DependTarget;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.util.ClassURL;

public class DependencyBuilder {
    public static Dependency buildJvmOption(List<String> arguments) {
        return new Dependency(null, new DependTarget.VMOption(DependencyBuilder.join(arguments)), null, null);
    }

    public static Dependency buildLoadClass(String className, StackTraceElement[] stacktrace, ProtectionDomain protectionDomain) {
        URL url = DependencyBuilder.getJar(protectionDomain);
        Dependency dependency = new Dependency(url, new DependTarget.Class(className, DependType.CLASS), stacktrace, url != null ? url.getFile() : null);
        return dependency;
    }

    private static URL getJar(ProtectionDomain protectionDomain) {
        if (protectionDomain != null && protectionDomain.getCodeSource() != null && protectionDomain.getCodeSource().getLocation() != null) {
            return protectionDomain.getCodeSource().getLocation();
        }
        return null;
    }

    public static Dependency buildCodeSource(URL location) {
        return new Dependency(null, new DependTarget.Location(location), null, location.getFile());
    }

    public static Dependency buildMethod(CallerInfo callerInfo, String className, String method) {
        Dependency dependency = new Dependency(ClassURL.create(callerInfo.getCallerClass().getName(), callerInfo.getCallerMethod()), new DependTarget.Method(className, method, "*", DependType.METHOD), callerInfo.getStacktrace(), DependencyBuilder.getFile(callerInfo.getCallerClass()));
        dependency.setCallerClass(callerInfo.getCallerClass());
        dependency.setCallerMethod(callerInfo.getCallerMethod());
        return dependency;
    }

    private static String getFile(Class callerClass) {
        URL url;
        CodeSource cs;
        ProtectionDomain pd;
        if (callerClass != null && (pd = callerClass.getProtectionDomain()) != null && (cs = pd.getCodeSource()) != null && (url = cs.getLocation()) != null) {
            return url.getFile();
        }
        return null;
    }

    public static Dependency buildMethod(CallerInfo callerInfo, String className, String method, Map<String, Object> context) {
        Dependency dependency = new Dependency(ClassURL.create(callerInfo.getCallerClass().getName(), callerInfo.getCallerMethod()), new DependTarget.Method(className, method, "*", DependType.METHOD), callerInfo.getStacktrace(), DependencyBuilder.getFile(callerInfo.getCallerClass()));
        dependency.setCallerClass(callerInfo.getCallerClass());
        dependency.setCallerMethod(callerInfo.getCallerMethod());
        dependency.setContext(context);
        return dependency;
    }

    public static Dependency buildDeepReflection(CallerInfo callerInfo, String className, StackTraceElement[] stackTrace) {
        return new Dependency(ClassURL.create(callerInfo.getCallerClass().getName(), callerInfo.getCallerMethod()), new DependTarget.Class(className, DependType.METHOD_TO_CLASS_DEEP_REFLECTION), stackTrace, DependencyBuilder.getFile(callerInfo.getCallerClass()));
    }

    private static String join(List<String> arguments) {
        if (null == arguments || arguments.isEmpty()) {
            return "";
        }
        return arguments.stream().collect(Collectors.joining(" "));
    }
}

