/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.methodvisitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emt4j.agent.common.MethodVisitorParam;
import org.eclipse.emt4j.common.MethodDesc;
import org.eclipse.emt4j.emt4j.agent.org.objectweb.asm.MethodVisitor;

public class TransformerFactory {
    private static Set<String> needTransformClassSet = new HashSet<String>();
    private static Set<String> needTransformClassInternalSet = new HashSet<String>();
    private static Map<String, Function<MethodVisitorParam, MethodVisitor>> methodToVisitorFactory = new HashMap<String, Function<MethodVisitorParam, MethodVisitor>>();

    public static void register(MethodDesc methodQuad, Function<MethodVisitorParam, MethodVisitor> methodVisitorFactory) {
        needTransformClassSet.add(methodQuad.getClassName());
        needTransformClassInternalSet.add(methodQuad.getInternalClassName());
        methodToVisitorFactory.put(TransformerFactory.key(methodQuad.getInternalClassName(), methodQuad.getMethodName(), methodQuad.getDesc()), methodVisitorFactory);
    }

    public static boolean needTransform(String className) {
        return needTransformClassSet.contains(className);
    }

    public static boolean needTransformByInternalClassName(String className) {
        return needTransformClassInternalSet.contains(className);
    }

    public static Function<MethodVisitorParam, MethodVisitor> getMethodVisitor(String internalClassName, String methodName, String desc) {
        return methodToVisitorFactory.get(TransformerFactory.key(internalClassName, methodName, desc));
    }

    private static String key(String internalClassName, String methodName, String desc) {
        return internalClassName + "_" + methodName + "_" + desc;
    }
}

