/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.rule;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emt4j.common.DependTarget;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.classanalyze.ClassInspectorInstance;
import org.eclipse.emt4j.common.rule.impl.ReferenceClassRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.util.ClassURL;
import org.eclipse.emt4j.common.util.JdkClassUtil;

@RuleImpl(type="reference-class", priority=1)
public class AgentReferenceClassRule
extends ReferenceClassRule {
    private String[] omitClassPrefix = new String[]{"sun.reflect.GeneratedMethodAccessor", "sun.reflect.GeneratedConstructorAccessor", "sun.reflect.GeneratedSerializationConstructorAccessor"};

    public AgentReferenceClassRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public CheckResult check(Dependency dependency) {
        if (this.shouldOmit(dependency.getTarget().asClass().getClassName())) {
            return CheckResult.PASS;
        }
        return super.check(dependency);
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.CLASS == dependency.getDependType() || DependType.METHOD_TO_CLASS_DEEP_REFLECTION == dependency.getDependType();
    }

    private boolean shouldOmit(String normalized) {
        for (String classPrefix : this.omitClassPrefix) {
            if (!normalized.startsWith(classPrefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Dependency> propagate(Dependency dependency) {
        if (!JdkClassUtil.isJdkClass(dependency.getTarget().asClass().getClassName()) && dependency.getCurrClassBytecode() != null) {
            Set<String> classSet = ClassInspectorInstance.getInstance().getReferenceClassSet(dependency.getCurrClassBytecode());
            classSet.retainAll(this.classPackageSet);
            return classSet.stream().map(c -> new Dependency(ClassURL.create(dependency.getLocationExternalForm(), dependency.getTarget().asClass().getClassName(), null), new DependTarget.Class((String)c, DependType.CLASS), null, dependency.getTargetFilePath())).collect(Collectors.toList());
        }
        return super.propagate(dependency);
    }
}

