/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.rule;

import java.util.Collections;
import org.eclipse.emt4j.agent.common.MethodVisitorParam;
import org.eclipse.emt4j.agent.common.methodvisitor.TransformerFactory;
import org.eclipse.emt4j.agent.common.rule.arrayslistoarray.ArraysToArrayVisitor;
import org.eclipse.emt4j.agent.common.rule.arrayslistoarray.ToArrayMethodVisitor;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.MethodDesc;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.classanalyze.ClassInspectorInstance;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;

@RuleImpl(type="arrays-as-list-to-array", priority=1)
public class ArraysAsListToArrayRule
extends ExecutableRule {
    private static final MethodDesc callMethod = new MethodDesc("java/util/Arrays$ArrayList", "java.util.Arrays$ArrayList", "toArray", "()[Ljava/lang/Object;");

    public ArraysAsListToArrayRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        TransformerFactory.register(callMethod, mvp -> new ArraysToArrayVisitor((MethodVisitorParam)mvp));
    }

    @Override
    public CheckResult check(Dependency dependency) {
        if (dependency.getTarget().asMethod().toMethodIdentifierNoDesc().equals(callMethod.getMethodIdentifierNoDesc())) {
            if (dependency.getCallerClass() != null && dependency.getCallerMethod() != null) {
                ToArrayMethodVisitor visitor = new ToArrayMethodVisitor();
                ClassInspectorInstance.getInstance().visitGivenMethodList(dependency.getCallerClass(), Collections.singletonList(dependency.getCallerMethod()), visitor);
                return visitor.isIncompatible() ? CheckResult.FAIL : CheckResult.PASS;
            }
            return CheckResult.FAIL;
        }
        return CheckResult.PASS;
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.METHOD == dependency.getDependType();
    }
}

