/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.rule;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emt4j.agent.common.MethodVisitorParam;
import org.eclipse.emt4j.agent.common.methodvisitor.TransformerFactory;
import org.eclipse.emt4j.agent.common.rule.getdeclarefield.GetDeclareFieldVisitor;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.MethodDesc;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.util.FileUtil;

@RuleImpl(type="get-declare-field", priority=1)
public class SecurityClassGetDeclareFieldRule
extends ExecutableRule {
    private String classListFile;
    private Set<String> securityClassSet = new HashSet<String>();
    private static final MethodDesc[] callMethods = new MethodDesc[]{new MethodDesc("java/lang/Class", "java.lang.Class", "getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;"), new MethodDesc("java/lang/Class", "java.lang.Class", "getField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;"), new MethodDesc("java/lang/Class", "java.lang.Class", "getDeclaredFields", "()[Ljava/lang/reflect/Field;"), new MethodDesc("java/lang/Class", "java.lang.Class", "getFields", "()[Ljava/lang/reflect/Field;")};

    public SecurityClassGetDeclareFieldRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        this.securityClassSet.addAll(FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.classListFile, false));
        for (MethodDesc methodQuad : callMethods) {
            TransformerFactory.register(methodQuad, mvp -> new GetDeclareFieldVisitor((MethodVisitorParam)mvp));
        }
    }

    @Override
    public CheckResult check(Dependency dependency) {
        String className;
        Object thisObject;
        if (Stream.of(callMethods).noneMatch(m -> m.getMethodIdentifierNoDesc().equals(dependency.getTarget().asMethod().toMethodIdentifierNoDesc()))) {
            return CheckResult.PASS;
        }
        if (dependency.getContext() != null && (thisObject = dependency.getContext().get("thisObject")) != null && thisObject instanceof Class && this.securityClassSet.contains(className = ((Class)thisObject).getName())) {
            return CheckResult.fail("className", className);
        }
        return CheckResult.PASS;
    }

    public String getClassListFile() {
        return this.classListFile;
    }

    public void setClassListFile(String classListFile) {
        this.classListFile = classListFile;
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.METHOD == dependency.getDependType();
    }
}

