/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.jdk8;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.emt4j.agent.common.jdkdependent.CallerInfo;
import org.eclipse.emt4j.agent.common.jdkdependent.CallerProvider;
import org.eclipse.emt4j.agent.common.jdkdependent.GuessCallerInfo;
import org.eclipse.emt4j.common.util.JdkClassUtil;
import sun.reflect.Reflection;

public class Java8CallerProvider
implements CallerProvider {
    @Override
    public Optional<GuessCallerInfo> guessCallers(int maxCallerNum) {
        if ("AgentReportWriteThread".equals(Thread.currentThread().getName())) {
            return Optional.empty();
        }
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        int foundNum = 0;
        String[] callerClassName = new String[maxCallerNum];
        for (int i = 0; i < stacktrace.length; ++i) {
            String cn = stacktrace[i].getClassName();
            if (cn.startsWith("org.eclipse.emt4j.agent") || cn.startsWith("org.eclipse.emt4j.common") || JdkClassUtil.isJdkClass(cn)) continue;
            if (foundNum >= maxCallerNum) break;
            callerClassName[foundNum++] = stacktrace[i].getClassName();
        }
        if (foundNum == 0) {
            return Optional.empty();
        }
        GuessCallerInfo guessCallerInfo = new GuessCallerInfo(foundNum);
        int matchedNum = 0;
        int i = 0;
        while (true) {
            Class callerClass;
            if ((callerClass = Reflection.getCallerClass((int)i)) == null) {
                return Optional.empty();
            }
            if (this.inList(callerClass.getName(), callerClassName)) {
                guessCallerInfo.getCallerClasses()[matchedNum++] = callerClass;
                if (matchedNum >= foundNum) break;
            }
            ++i;
        }
        guessCallerInfo.setStacktrace(stacktrace);
        return Optional.of(guessCallerInfo);
    }

    private boolean inList(String name, String[] callerClassName) {
        for (int i = 0; i < callerClassName.length; ++i) {
            if (callerClassName[i] == null || !callerClassName[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<Class> getNonJdkCallerByDepth(int callerDepth) {
        if ("AgentReportWriteThread".equals(Thread.currentThread().getName())) {
            return Optional.empty();
        }
        Class callerClass = Reflection.getCallerClass((int)callerDepth);
        if (callerClass == null || JdkClassUtil.isJdkClass(callerClass.getName())) {
            return Optional.empty();
        }
        return Optional.of(callerClass);
    }

    @Override
    public Optional<CallerInfo> getCallerInfo(Class callerClass, int from) {
        StackTraceElement[] stacktrace;
        for (StackTraceElement st : stacktrace = Thread.currentThread().getStackTrace()) {
            if (!st.getClassName().equals(callerClass.getName())) continue;
            CallerInfo callerInfo = new CallerInfo();
            callerInfo.setCallerClass(callerClass);
            callerInfo.setCallerMethod(st.getMethodName());
            callerInfo.setCalleeClass(stacktrace[from].getClassName());
            callerInfo.setCalleeMethod(stacktrace[from].getMethodName());
            callerInfo.setStacktrace(Arrays.copyOfRange(stacktrace, from, stacktrace.length));
            return Optional.of(callerInfo);
        }
        return Optional.empty();
    }
}

