/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.i18n;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emt4j.common.CallFrame;
import org.eclipse.emt4j.common.CheckResultContext;
import org.eclipse.emt4j.common.CheckResultGroup;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.IssueContext;
import org.eclipse.emt4j.common.i18n.ReportResourceAccessor;
import org.eclipse.emt4j.common.util.CheckResultGroupUtil;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.TemplateRuntime;

public class I18nResourceUnit {
    protected static final String SIGN = "+++ ";
    private final ReportResourceAccessor reportResourceAccessor;
    private final String i18nBase;
    private String title;
    private String description;
    private String descriptionTitle;
    private String solution;
    private String solutionTitle;
    private String issueContextTitle;
    private String resultCode;
    private String subResultCode;
    private Set<String> solutionSet = new HashSet<String>();
    private List<IssueContext> issueContextList = new ArrayList<IssueContext>();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void render(List<CheckResultContext> checkResultContextList) {
        this.renderSolution(checkResultContextList);
        this.renderIssueContext(checkResultContextList);
    }

    private void renderIssueContext(List<CheckResultContext> checkResultContextList) {
        for (CheckResultGroup checkResultGroup : CheckResultGroupUtil.group(checkResultContextList)) {
            Set<String> issueContextSet = this.getIssueContext(checkResultGroup, this.i18nBase);
            if (issueContextSet.isEmpty()) continue;
            IssueContext issueContext = new IssueContext();
            this.issueContextList.add(issueContext);
            issueContext.getContextDesc().addAll(issueContextSet);
            if (checkResultGroup.getStackTrace() == null || checkResultGroup.getStackTrace().isEmpty()) continue;
            for (int i = 0; i < checkResultGroup.getStackTrace().size(); ++i) {
                boolean moreThenMoreFrame = false;
                for (CallFrame frame : checkResultGroup.getDiffStackTraceFrame()) {
                    if (frame.getPos() != i) continue;
                    issueContext.getStackTrace().add(SIGN + frame.getFrameContent());
                    moreThenMoreFrame = true;
                }
                issueContext.getStackTrace().add(moreThenMoreFrame ? SIGN + checkResultGroup.getStackTrace().get(i) : checkResultGroup.getStackTrace().get(i));
            }
        }
    }

    public Optional<String> getIssueContext(CheckResultContext checkResult, String i18nBase) {
        Dependency dependency = checkResult.getDependency();
        ResourceBundle common = this.reportResourceAccessor.getCommonResourceBundle(i18nBase);
        if (dependency.getLocationExternalForm() != null) {
            return this.buildIssueContext(String.format(common.getString("issue.context.location.target"), dependency.getLocationExternalForm(), dependency.getTarget().desc()));
        }
        return this.buildIssueContext(String.format(common.getString("issue.context.target"), dependency.getTarget().desc()));
    }

    private void renderSolution(List<CheckResultContext> checkResultContextList) {
        for (CheckResultContext checkResult : checkResultContextList) {
            if (checkResult.getReportCheckResult().getContext() != null) {
                String result = ((String)TemplateRuntime.eval(this.solution, checkResult.getReportCheckResult().getContext())).trim();
                for (String s : result.split("\\\\newline")) {
                    if (null == s || "".equals(s.trim())) continue;
                    this.solutionSet.add(s.trim());
                }
                continue;
            }
            this.solutionSet.add(this.solution);
        }
    }

    private Optional<String> buildIssueContext(String contextStr) {
        return contextStr == null || "".equals(contextStr) ? Optional.empty() : Optional.of(contextStr);
    }

    private Set<String> getIssueContext(CheckResultGroup checkResultGroup, String i18nBase) {
        return checkResultGroup.getCheckResultContextList().stream().map(c -> this.getIssueContext((CheckResultContext)c, i18nBase)).filter(c -> c.isPresent()).map(c -> (String)c.get()).collect(Collectors.toSet());
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionTitle() {
        return this.descriptionTitle;
    }

    public void setDescriptionTitle(String descriptionTitle) {
        this.descriptionTitle = descriptionTitle;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public String getSolutionTitle() {
        return this.solutionTitle;
    }

    public void setSolutionTitle(String solutionTitle) {
        this.solutionTitle = solutionTitle;
    }

    public String getIssueContextTitle() {
        return this.issueContextTitle;
    }

    public void setIssueContextTitle(String issueContextTitle) {
        this.issueContextTitle = issueContextTitle;
    }

    public I18nResourceUnit(String resultCode, String subResultCode, ReportResourceAccessor reportResourceAccessor, String i18nBase) {
        this.resultCode = resultCode;
        this.subResultCode = subResultCode;
        this.reportResourceAccessor = reportResourceAccessor;
        this.i18nBase = i18nBase;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getSubResultCode() {
        return this.subResultCode;
    }

    public void setSubResultCode(String subResultCode) {
        this.subResultCode = subResultCode;
    }

    public Set<String> getSolutionSet() {
        return this.solutionSet;
    }

    public void setSolutionSet(Set<String> solutionSet) {
        this.solutionSet = solutionSet;
    }

    public List<IssueContext> getIssueContextList() {
        return this.issueContextList;
    }

    public void setIssueContextList(List<IssueContext> issueContextList) {
        this.issueContextList = issueContextList;
    }
}

