/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.rule.model.ReportCheckResult;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.TemplateRuntime;

public abstract class ExecutableRule {
    protected final ConfRuleItem confRuleItem;
    protected final ConfRules confRules;

    public ExecutableRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        this.confRuleItem = confRuleItem;
        this.confRules = confRules;
    }

    public abstract void init();

    public List<Dependency> propagate(Dependency dependency) {
        return Collections.emptyList();
    }

    public ReportCheckResult execute(Dependency dependency) {
        CheckResult checkResult = this.check(dependency);
        if (checkResult.isPass()) {
            return ReportCheckResult.PASS;
        }
        ReportCheckResult reportCheckResult = new ReportCheckResult(false);
        reportCheckResult.setPriority(this.confRuleItem.getPriority());
        reportCheckResult.setContext(checkResult.getContext());
        reportCheckResult.setResultCode(this.evalIfNeed(this.confRuleItem.getResultCode(), checkResult.getContext()));
        reportCheckResult.setSubResultCode(this.evalIfNeed(this.confRuleItem.getSubResultCode(), checkResult.getContext()));
        reportCheckResult.setPropagated(checkResult.getPropagated());
        return reportCheckResult;
    }

    private String evalIfNeed(String maybeMvel2Expr, Map<String, Object> context) {
        if (null == maybeMvel2Expr || "".equals(maybeMvel2Expr) || null == context || context.isEmpty()) {
            return maybeMvel2Expr;
        }
        return (String)TemplateRuntime.eval(maybeMvel2Expr, context);
    }

    protected abstract CheckResult check(Dependency var1);

    public abstract boolean accept(Dependency var1);

    public ConfRuleItem getConfRuleItem() {
        return this.confRuleItem;
    }

    public ConfRules getConfRules() {
        return this.confRules;
    }
}

