/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emt4j.common.JdkMigrationException;
import org.eclipse.emt4j.common.rule.ConfRuleFacade;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.RuleSelector;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;

public class InstanceRuleManager {
    private static volatile boolean hasInit = false;
    private static List<ExecutableRule> ruleInstanceList = null;

    public static synchronized void init(String[] classList, String[] features, String[] modes, int fromVersion, int toVersion, String priority) {
        if (hasInit) {
            return;
        }
        try {
            ArrayList<ExecutableRule> instanceList = new ArrayList<ExecutableRule>();
            List<ConfRules> confRulesList = ConfRuleFacade.load(features, modes, fromVersion, toVersion);
            Map<String, Class> ruleMap = RuleSelector.select(classList);
            int priorityLimit = InstanceRuleManager.toIntPriority(priority);
            for (ConfRules confRules : confRulesList) {
                for (ConfRuleItem ruleItem : confRules.getRuleItems()) {
                    if (InstanceRuleManager.toIntPriority(ruleItem.getPriority()) > priorityLimit) continue;
                    Class c = ruleMap.get(ruleItem.getType());
                    if (null == c) {
                        throw new JdkMigrationException("Cannot found rule implementation for type : " + ruleItem.getType());
                    }
                    Constructor constructor = c.getConstructor(ConfRuleItem.class, ConfRules.class);
                    if (null == constructor) {
                        throw new JdkMigrationException("The class: " + c.getName() + " is not a valid implementation of ExecutableRule!");
                    }
                    ExecutableRule executableRule = (ExecutableRule)constructor.newInstance(ruleItem, confRules);
                    if (ruleItem.getUserDefineAttrs() != null) {
                        for (String[] nameValue : ruleItem.getUserDefineAttrs()) {
                            InstanceRuleManager.setValue(executableRule, nameValue[0], nameValue[1]);
                        }
                    }
                    executableRule.init();
                    instanceList.add(executableRule);
                }
            }
            ruleInstanceList = Collections.unmodifiableList(instanceList);
            hasInit = true;
        }
        catch (Exception e) {
            throw new JdkMigrationException("InstanceRuleManager init exception!", e);
        }
    }

    private static void setValue(ExecutableRule executableRule, String attrName, String attrValue) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method m = executableRule.getClass().getMethod(InstanceRuleManager.getSetMethodName(attrName), String.class);
        m.setAccessible(true);
        m.invoke((Object)executableRule, attrValue);
    }

    private static String getSetMethodName(String attrName) {
        StringBuilder setMethodName = new StringBuilder(attrName.length() + "set".length());
        setMethodName.append("set");
        char[] chars = attrName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            if (i == 0 || i != 0 && chars[i - 1] == '-') {
                setMethodName.append(Character.toUpperCase(chars[i]));
                continue;
            }
            setMethodName.append(chars[i]);
        }
        return setMethodName.toString();
    }

    public static List<ExecutableRule> getRuleInstanceList() {
        return ruleInstanceList;
    }

    private static int toIntPriority(String priority) {
        if (priority == null) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(priority.substring(1));
        }
        catch (Throwable t) {
            return Integer.MAX_VALUE;
        }
    }
}

