/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.util.ClassUtil;
import org.eclipse.emt4j.common.util.FileUtil;

@RuleImpl(type="add-exports")
public class AddExportsRule
extends ExecutableRule {
    private String packagesFile;
    private String moduleToPackageFile;
    private String defaultExportsFile;
    protected Map<String, String> exportPackageToModule = new HashMap<String, String>();
    private Set<String> packageSet = new HashSet<String>();
    protected Set<String> jdkDefaultExportToUnnamed = new HashSet<String>();

    public AddExportsRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.moduleToPackageFile, false).forEach(l -> {
            String[] arr = l.split(",");
            this.exportPackageToModule.put(arr[0].trim(), arr[1].trim());
        });
        this.packageSet.addAll(FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.packagesFile, false));
        this.jdkDefaultExportToUnnamed.addAll(FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.defaultExportsFile, false));
    }

    @Override
    public CheckResult check(Dependency dependency) {
        String className = dependency.getTarget().asClass().getClassName();
        Optional<String> packageName = ClassUtil.getPackage(className);
        if (!packageName.isPresent()) {
            return CheckResult.PASS;
        }
        if (packageName.get().startsWith("com.sun.proxy")) {
            return CheckResult.PASS;
        }
        if (this.matchModule(packageName.get()) != null) {
            return CheckResult.PASS;
        }
        Set<String> typeSet = dependency.getClassSymbol().getTypeSet();
        HashSet<String> shouldExports = new HashSet<String>();
        for (String type : typeSet) {
            String[] modAndPkg;
            packageName = ClassUtil.getPackage(type);
            if (!packageName.isPresent() || this.jdkDefaultExportToUnnamed.contains(packageName.get()) || (modAndPkg = this.matchModule(packageName.get())) == null || "java.base".equals(modAndPkg[0]) || !this.packageSet.contains(modAndPkg[1])) continue;
            shouldExports.add(modAndPkg[0] + "/" + modAndPkg[1]);
        }
        if (shouldExports.isEmpty()) {
            return CheckResult.PASS;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("shouldExports", shouldExports);
        StackTraceElement[] stacktrace = dependency.getStacktrace();
        int index = -1;
        if (stacktrace != null) {
            for (int i = stacktrace.length - 1; i >= 0; --i) {
                if ("java.lang.ClassLoader".equals(stacktrace[i].getClassName()) && "loadClass".equals(stacktrace[i].getMethodName())) {
                    index = i;
                    break;
                }
                if (!"java.lang.Class".equals(stacktrace[i].getClassName()) || !"forName".equals(stacktrace[i].getMethodName())) continue;
                index = i;
                break;
            }
        }
        if (index != -1) {
            dependency.setStacktrace(Arrays.copyOfRange(stacktrace, index + 1, stacktrace.length));
        }
        return CheckResult.fail(context);
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.WHOLE_CLASS == dependency.getDependType();
    }

    private String[] matchModule(String packageName) {
        String currPackage = packageName;
        String module = this.exportPackageToModule.get(packageName);
        if (module == null) {
            int index = packageName.lastIndexOf(46);
            while (index != -1) {
                currPackage = packageName.substring(0, index);
                module = this.exportPackageToModule.get(currPackage);
                if (module != null) {
                    return new String[]{module, currPackage};
                }
                index = packageName.substring(0, index).lastIndexOf(46);
            }
            return null;
        }
        return new String[]{module, currPackage};
    }

    private CheckResult buildAddExportOption(String sourceModule, String sourcePackage) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("sourceModule", sourceModule);
        context.put("sourcePackage", sourcePackage);
        return CheckResult.fail(context);
    }

    public void setPackagesFile(String packagesFile) {
        this.packagesFile = packagesFile;
    }

    public void setModuleToPackageFile(String moduleToPackageFile) {
        this.moduleToPackageFile = moduleToPackageFile;
    }

    public void setDefaultExportsFile(String defaultExportsFile) {
        this.defaultExportsFile = defaultExportsFile;
    }
}

