/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.JdkMigrationException;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.rule.model.VmOptionItem;
import org.eclipse.emt4j.common.util.FileUtil;

@RuleImpl(type="jvm-option")
public class JvmOptionRule
extends ExecutableRule {
    private String jvmOptionFile;
    private Map<String, VmOptionItem> deprecatedVmOptionMap;

    public JvmOptionRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public CheckResult check(Dependency dependency) {
        String[] givenOptions = dependency.getTarget().asVMOption().getVmOption().split("\\s+");
        ArrayList expired = new ArrayList();
        ArrayList obsoleted = new ArrayList();
        ArrayList deprecated = new ArrayList();
        for (String givenOption : givenOptions) {
            this.containAny(givenOption, foundOption -> {
                if (foundOption.getExpiredVersion() != null && this.betweenInVersion(foundOption.getExpiredVersion())) {
                    expired.add(givenOption);
                } else if (foundOption.getObsoleteVersion() != null && this.betweenInVersion(foundOption.getObsoleteVersion())) {
                    obsoleted.add(givenOption);
                } else if (foundOption.getDeprecatedVersion() != null && this.betweenInVersion(foundOption.getDeprecatedVersion())) {
                    deprecated.add(givenOption);
                } else {
                    expired.add(givenOption);
                }
            });
        }
        if (expired.isEmpty() && obsoleted.isEmpty() && deprecated.isEmpty()) {
            return CheckResult.PASS;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("expired", expired);
        map.put("obsoleted", obsoleted);
        map.put("deprecated", deprecated);
        return CheckResult.fail(map);
    }

    private void containAny(String givenOption, Consumer<VmOptionItem> foundConsumer) {
        this.deprecatedVmOptionMap.forEach((k, v) -> {
            if (givenOption.contains((CharSequence)k)) {
                foundConsumer.accept((VmOptionItem)v);
            }
        });
    }

    @Override
    public void init() {
        this.deprecatedVmOptionMap = new HashMap<String, VmOptionItem>();
        List<String> lines = FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.jvmOptionFile, false);
        int lineNo = 0;
        for (String line : lines) {
            String[] arr = line.split(",");
            this.checkFormat(arr, line, ++lineNo);
            VmOptionItem vmSpecialOption = new VmOptionItem();
            if (arr.length >= 2) {
                vmSpecialOption.setDeprecatedVersion(this.convert(arr[1]));
            }
            if (arr.length >= 3) {
                vmSpecialOption.setObsoleteVersion(this.convert(arr[2]));
            }
            if (arr.length >= 4) {
                vmSpecialOption.setExpiredVersion(this.convert(arr[3]));
            }
            if (arr.length >= 5) {
                vmSpecialOption.setSuggestion(this.emptyIfDefault(arr[4]));
            }
            this.deprecatedVmOptionMap.put(arr[0], vmSpecialOption);
        }
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.VM_OPTION == dependency.getDependType();
    }

    public boolean betweenInVersion(int currentVersion) {
        return currentVersion >= this.confRules.getFromVersion() && currentVersion <= this.confRules.getToVersion();
    }

    public String getJvmOptionFile() {
        return this.jvmOptionFile;
    }

    public void setJvmOptionFile(String jvmOptionFile) {
        this.jvmOptionFile = jvmOptionFile;
    }

    private String emptyIfDefault(String str) {
        return "-".equals(str) ? "" : str;
    }

    private Integer convert(String origin) {
        String trimmed = origin.trim();
        return "-".equals(trimmed) ? null : Integer.valueOf(trimmed);
    }

    private void checkFormat(String[] arr, String line, int lineNo) {
        if (arr.length == 0) {
            throw new JdkMigrationException("Content at line  " + lineNo + " is malformed!content is : " + line);
        }
        for (String col : arr) {
            if (col != null && !"".equals(col)) continue;
            throw new JdkMigrationException("Content at line " + lineNo + " is malformed!content is : " + line);
        }
    }
}

