/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.staticanalysis.impl;

import java.util.List;
import java.util.Set;
import org.eclipse.emt4j.common.staticanalysis.impl.BaseAnalyzer;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.JimpleBody;
import soot.jimple.internal.JVirtualInvokeExpr;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class CLDRNumberFormatAnalyzer
extends BaseAnalyzer {
    @Override
    public String rule() {
        return "cldr-number-format";
    }

    @Override
    boolean doAnalyze(SootMethod method) {
        JimpleBody body = (JimpleBody)method.retrieveActiveBody();
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body);
        SimpleLocalDefs localDefs = new SimpleLocalDefs(graph);
        for (Unit unit : body.getUnits()) {
            List<ValueBox> boxes = unit.getUseBoxes();
            for (ValueBox box : boxes) {
                List<ValueBox> useBoxes;
                Local local;
                JVirtualInvokeExpr invoke;
                SootMethod invokeMethod;
                String className;
                Value value = box.getValue();
                if (!(value instanceof JVirtualInvokeExpr) || !(className = (invokeMethod = (invoke = (JVirtualInvokeExpr)value).getMethod()).getDeclaringClass().getName()).equals("java.text.NumberFormat") && !className.equals("java.text.DecimalFormat") && !className.equals("java.text.Format") || !invokeMethod.getName().equals("format") && !invokeMethod.getName().equals("parse") || invokeMethod.getParameterCount() <= 0 || !CLDRNumberFormatAnalyzer.isTarget(localDefs, unit, local = (Local)(useBoxes = invoke.getUseBoxes()).get(0).getValue(), graph)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTarget(SimpleLocalDefs localDefs, Unit unit, Local local, UnitGraph unitGraph) {
        Set<Unit> units = CLDRNumberFormatAnalyzer.getDefUnits(localDefs, unit, local);
        for (Unit unit1 : units) {
            SimpleLocalUses localUses = new SimpleLocalUses(unitGraph, (LocalDefs)localDefs);
            List<UnitValueBoxPair> pairList = localUses.getUsesOf(unit1);
            for (UnitValueBoxPair pair : pairList) {
                List<ValueBox> boxes = pair.unit.getUseBoxes();
                for (ValueBox box : boxes) {
                    JVirtualInvokeExpr invoke;
                    SootMethod invokeMethod;
                    String className;
                    Value value = box.getValue();
                    if (!(value instanceof JVirtualInvokeExpr) || !(className = (invokeMethod = (invoke = (JVirtualInvokeExpr)value).getMethod()).getDeclaringClass().getName()).equals("java.text.NumberFormat") && !className.equals("java.text.DecimalFormat") && !className.equals("java.text.Format") || !invokeMethod.getName().equals("setCurrency") || invokeMethod.getParameterCount() <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

