/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.emt4j.common.CheckResultContext;
import org.eclipse.emt4j.common.CheckResultGroup;

public class CheckResultGroupUtil {
    public static List<CheckResultGroup> group(List<CheckResultContext> checkResultContextList) {
        LinkedList<CheckResultContext> workset = new LinkedList<CheckResultContext>(checkResultContextList);
        ArrayList<CheckResultGroup> groups = new ArrayList<CheckResultGroup>();
        while (!workset.isEmpty()) {
            CheckResultContext first = workset.removeFirst();
            List<String> baseStackTrace = CheckResultGroupUtil.stackTraceToArray(first);
            CheckResultGroup group = CheckResultGroup.createBase(first, baseStackTrace);
            groups.add(group);
            if (baseStackTrace.isEmpty() || workset.isEmpty()) continue;
            Iterator iter = workset.iterator();
            while (iter.hasNext()) {
                CheckResultContext toCompare = (CheckResultContext)iter.next();
                List<String> nowStackTrace = CheckResultGroupUtil.stackTraceToArray(toCompare);
                if (nowStackTrace.isEmpty()) {
                    groups.add(CheckResultGroup.createBase(toCompare, CheckResultGroupUtil.stackTraceToArray(toCompare)));
                    iter.remove();
                    continue;
                }
                if (baseStackTrace.size() != nowStackTrace.size()) continue;
                CheckResultGroupUtil.findDiff(baseStackTrace, nowStackTrace, diffPos -> {
                    iter.remove();
                    if (diffPos != -1) {
                        group.appendStackTraceDifference(toCompare, (int)diffPos, (String)nowStackTrace.get((int)diffPos));
                    }
                });
            }
        }
        return groups;
    }

    private static void findDiff(List<String> baseStackTrace, List<String> nowStackTrace, Consumer<Integer> diffConsumer) {
        int lastDiffPos = -1;
        int diffNum = 0;
        for (int i = 0; i < baseStackTrace.size(); ++i) {
            if (baseStackTrace.get(i).equals(nowStackTrace.get(i))) continue;
            lastDiffPos = i;
            if (++diffNum > 1) break;
        }
        if (diffNum == 0 || diffNum == 1) {
            diffConsumer.accept(lastDiffPos);
        }
    }

    private static List<String> stackTraceToArray(CheckResultContext checkResultContext) {
        if (checkResultContext.getDependency().getStacktrace() != null) {
            return Arrays.stream(checkResultContext.getDependency().getStacktrace()).map(s -> s.toString()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

