/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.emt4j.agent.org.mvel2.ast;

import org.eclipse.emt4j.emt4j.agent.org.mvel2.CompileException;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.MVEL;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.ParserContext;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.ast.ASTNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.compiler.ExecutableStatement;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.integration.VariableResolverFactory;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.util.ParseTools;

public class Negation
extends ASTNode {
    private ExecutableStatement stmt;

    public Negation(char[] expr, int start, int offset, int fields, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        if ((fields & 0x10) != 0 && (this.stmt = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx)).getKnownEgressType() != null && !ParseTools.boxPrimitive(this.stmt.getKnownEgressType()).isAssignableFrom(Boolean.class)) {
            throw new CompileException("negation operator cannot be applied to non-boolean type", expr, start);
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return (Boolean)this.stmt.getValue(ctx, thisValue, factory) == false;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return (Boolean)MVEL.eval(this.expr, this.start, this.offset, ctx, factory) == false;
        }
        catch (NullPointerException e) {
            throw new CompileException("negation operator applied to a null value", this.expr, this.start, e);
        }
        catch (ClassCastException e) {
            throw new CompileException("negation operator applied to non-boolean expression", this.expr, this.start, e);
        }
    }

    @Override
    public Class getEgressType() {
        return Boolean.class;
    }

    public ExecutableStatement getStatement() {
        return this.stmt;
    }
}

