/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.emt4j.agent.org.mvel2.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.ConversionException;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.ConversionHandler;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.conversion.Converter;

public class ShortCH
implements ConversionHandler {
    private static final Short TRUE = 1;
    private static final Short FALSE = 0;
    private static Converter stringConverter = new Converter(){

        @Override
        public Short convert(Object o) {
            return Short.parseShort((String)o);
        }
    };
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    @Override
    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Short.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    @Override
    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            @Override
            public Object convert(Object o) {
                return stringConverter.convert(String.valueOf(o));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            @Override
            public Short convert(Object o) {
                return ((BigDecimal)o).shortValue();
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            @Override
            public Short convert(Object o) {
                return ((BigInteger)o).shortValue();
            }
        });
        CNV.put(Short.class, new Converter(){

            @Override
            public Object convert(Object o) {
                return o;
            }
        });
        CNV.put(Integer.class, new Converter(){

            @Override
            public Short convert(Object o) {
                if ((Integer)o > Short.MAX_VALUE) {
                    throw new ConversionException("cannot coerce Integer to Short since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return ((Integer)o).shortValue();
            }
        });
        CNV.put(Float.class, new Converter(){

            @Override
            public Short convert(Object o) {
                if (((Float)o).floatValue() > 32767.0f) {
                    throw new ConversionException("cannot coerce Float to Short since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return ((Float)o).shortValue();
            }
        });
        CNV.put(Double.class, new Converter(){

            @Override
            public Short convert(Object o) {
                if ((Double)o > 32767.0) {
                    throw new ConversionException("cannot coerce Double to Short since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return ((Double)o).shortValue();
            }
        });
        CNV.put(Long.class, new Converter(){

            @Override
            public Short convert(Object o) {
                if ((Long)o > 32767L) {
                    throw new ConversionException("cannot coerce Integer to Short since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return ((Long)o).shortValue();
            }
        });
        CNV.put(Boolean.class, new Converter(){

            @Override
            public Short convert(Object o) {
                if (((Boolean)o).booleanValue()) {
                    return TRUE;
                }
                return FALSE;
            }
        });
    }
}

