/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.emt4j.agent.org.mvel2.integration.impl;

import org.eclipse.emt4j.emt4j.agent.org.mvel2.integration.VariableResolver;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.integration.VariableResolverFactory;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.integration.impl.BaseVariableResolverFactory;

public class ItemResolverFactory
extends BaseVariableResolverFactory {
    private final ItemResolver resolver;

    public ItemResolverFactory(ItemResolver resolver, VariableResolverFactory nextFactory) {
        this.resolver = resolver;
        this.nextFactory = nextFactory;
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        if (this.isTarget(name)) {
            this.resolver.setValue(value);
            return this.resolver;
        }
        return this.nextFactory.createVariable(name, value);
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        if (this.isTarget(name)) {
            throw new RuntimeException("variable already defined in scope: " + name);
        }
        return this.nextFactory.createVariable(name, value);
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        return this.isTarget(name) ? this.resolver : this.nextFactory.getVariableResolver(name);
    }

    @Override
    public boolean isTarget(String name) {
        return this.resolver.getName().equals(name);
    }

    @Override
    public boolean isResolveable(String name) {
        return this.resolver.getName().equals(name) || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    public static class ItemResolver
    implements VariableResolver {
        private final String name;
        private Class type = Object.class;
        public Object value;

        public ItemResolver(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public ItemResolver(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.type;
        }

        @Override
        public void setStaticType(Class type) {
            this.type = type;
        }

        @Override
        public int getFlags() {
            return 0;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            this.value = value;
        }
    }
}

