/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.emt4j.agent.org.mvel2.optimizers.dynamic;

import org.eclipse.emt4j.emt4j.agent.org.mvel2.ParserContext;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.compiler.Accessor;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.integration.VariableResolverFactory;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.optimizers.OptimizerFactory;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.optimizers.dynamic.DynamicAccessor;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.optimizers.dynamic.DynamicOptimizer;

public class DynamicCollectionAccessor
implements DynamicAccessor {
    private ParserContext pCtx;
    private Object rootObject;
    private Class colType;
    private char[] property;
    private int start;
    private int offset;
    private long stamp;
    private int type;
    private int runcount;
    private boolean opt = false;
    private Accessor _safeAccessor;
    private Accessor _accessor;

    public DynamicCollectionAccessor(ParserContext pCtx, Object rootObject, Class colType, char[] property, int start, int offset, int type, Accessor _accessor) {
        this.pCtx = pCtx;
        this.rootObject = rootObject;
        this.colType = colType;
        this._safeAccessor = this._accessor = _accessor;
        this.type = type;
        this.property = property;
        this.start = start;
        this.offset = offset;
        this.stamp = System.currentTimeMillis();
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            if (System.currentTimeMillis() - this.stamp < DynamicOptimizer.timeSpan) {
                this.opt = true;
                return this.optimize(this.pCtx, ctx, elCtx, variableFactory);
            }
            this.runcount = 0;
            this.stamp = System.currentTimeMillis();
        }
        return this._accessor.getValue(ctx, elCtx, variableFactory);
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        ++this.runcount;
        return this._accessor.setValue(ctx, elCtx, variableFactory, value);
    }

    private Object optimize(ParserContext pCtx, Object ctx, Object elCtx, VariableResolverFactory variableResolverFactory) {
        if (DynamicOptimizer.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        this._accessor = OptimizerFactory.getAccessorCompiler("ASM").optimizeCollection(pCtx, this.rootObject, this.colType, this.property, this.start, this.offset, ctx, elCtx, variableResolverFactory);
        return this._accessor.getValue(ctx, elCtx, variableResolverFactory);
    }

    @Override
    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
        this.stamp = System.currentTimeMillis();
    }

    public long getStamp() {
        return this.stamp;
    }

    public int getRuncount() {
        return this.runcount;
    }

    @Override
    public Class getKnownEgressType() {
        return this.colType;
    }
}

