/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.emt4j.agent.org.mvel2.templates;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.CompileException;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.ParserContext;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.CompiledTemplate;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CodeNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CommentNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CompiledCodeNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CompiledDeclareNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CompiledEvalNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CompiledExpressionNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CompiledForEachNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CompiledIfNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CompiledIncludeNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CompiledNamedIncludeNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.CompiledTerminalExpressionNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.DeclareNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.EndNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.EvalNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.ExpressionNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.ForEachNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.IfNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.IncludeNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.NamedIncludeNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.Node;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.TerminalExpressionNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.TerminalNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.res.TextNode;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.templates.util.TemplateTools;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.util.ExecutionStack;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.util.ParseTools;

public class TemplateCompiler {
    private char[] template;
    private int length;
    private int start;
    private int cursor;
    private int lastTextRangeEnding;
    private int line;
    private int colStart;
    private boolean codeCache = false;
    private Map<String, Class<? extends Node>> customNodes;
    private ParserContext parserContext;
    private static final Map<String, Integer> OPCODES = new HashMap<String, Integer>();

    public CompiledTemplate compile() {
        return new CompiledTemplate(this.template, this.compileFrom(null, new ExecutionStack()));
    }

    public Node compileFrom(Node root, ExecutionStack stack) {
        this.line = 1;
        Node n = root;
        if (root == null) {
            n = root = new TextNode(0, 0);
        }
        try {
            block21: while (this.cursor < this.length) {
                block2 : switch (this.template[this.cursor]) {
                    case '\n': {
                        ++this.line;
                        this.colStart = this.cursor + 1;
                        break;
                    }
                    case '$': 
                    case '@': {
                        if (this.isNext(this.template[this.cursor])) {
                            this.start = ++this.cursor;
                            n = this.markTextNode(n);
                            n.setEnd(n.getEnd() + 1);
                            this.lastTextRangeEnding = ++this.cursor;
                            this.start = this.cursor;
                            continue block21;
                        }
                        int x = this.captureOrbToken();
                        if (x == -1) break;
                        this.start = x;
                        String name = new String(this.capture());
                        Integer opcode = OPCODES.get(name);
                        switch (opcode == null ? 0 : opcode) {
                            case 1: {
                                this.markTextNode((Node)n).next = this.codeCache ? new CompiledIfNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext) : new IfNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                n = this.markTextNode((Node)n).next;
                                stack.push(this.markTextNode((Node)n).next);
                                n.setTerminus(new TerminalNode());
                                break block2;
                            }
                            case 2: {
                                if (stack.isEmpty() || !(stack.peek() instanceof IfNode)) break block2;
                                IfNode last = (IfNode)stack.pop();
                                this.markTextNode((Node)n).next = last.getTerminus();
                                last.demarcate(last.getTerminus(), this.template);
                                n = this.codeCache ? new CompiledIfNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext) : new IfNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                last.next = n;
                                n.setTerminus(last.getTerminus());
                                stack.push(n);
                                break block2;
                            }
                            case 3: {
                                this.markTextNode((Node)n).next = this.codeCache ? new CompiledForEachNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext) : new ForEachNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                n = this.markTextNode((Node)n).next;
                                stack.push(this.markTextNode((Node)n).next);
                                n.setTerminus(new TerminalNode());
                                break block2;
                            }
                            case 50: {
                                Node node;
                                Node node2 = this.markTextNode(n);
                                if (this.codeCache) {
                                    this.start = this.cursor + 1;
                                    node = new CompiledIncludeNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                                } else {
                                    this.start = this.cursor + 1;
                                    node = new IncludeNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                }
                                node2.next = node;
                                n = node;
                                break block2;
                            }
                            case 51: {
                                Node node;
                                Node node3 = this.markTextNode(n);
                                if (this.codeCache) {
                                    this.start = this.cursor + 1;
                                    node = new CompiledNamedIncludeNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                                } else {
                                    this.start = this.cursor + 1;
                                    node = new NamedIncludeNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                }
                                node3.next = node;
                                n = node;
                                break block2;
                            }
                            case 53: {
                                Node node;
                                Node node4 = this.markTextNode(n);
                                if (this.codeCache) {
                                    this.start = this.cursor + 1;
                                    node = new CompiledCodeNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                                } else {
                                    this.start = this.cursor + 1;
                                    node = new CodeNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                }
                                node4.next = node;
                                n = node;
                                break block2;
                            }
                            case 55: {
                                Node node;
                                Node node5 = this.markTextNode(n);
                                if (this.codeCache) {
                                    this.start = this.cursor + 1;
                                    node = new CompiledEvalNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                                } else {
                                    this.start = this.cursor + 1;
                                    node = new EvalNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                }
                                node5.next = node;
                                n = node;
                                break block2;
                            }
                            case 52: {
                                this.start = this.cursor + 1;
                                n = this.markTextNode((Node)n).next = new CommentNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                break block2;
                            }
                            case 54: {
                                Node node;
                                Node node6 = this.markTextNode(n);
                                if (this.codeCache) {
                                    this.start = this.cursor + 1;
                                    node = new CompiledDeclareNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                                } else {
                                    this.start = this.cursor + 1;
                                    node = new DeclareNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                }
                                node6.next = node;
                                n = node;
                                stack.push(node);
                                n.setTerminus(new TerminalNode());
                                break block2;
                            }
                            case 10: {
                                n = this.markTextNode(n);
                                Node end = (Node)stack.pop();
                                Node terminal2 = end.getTerminus();
                                terminal2.setCStart(this.captureOrbInternal());
                                this.lastTextRangeEnding = this.start;
                                terminal2.setEnd(this.lastTextRangeEnding - 1);
                                terminal2.calculateContents(this.template);
                                if (end.demarcate(terminal2, this.template)) {
                                    n = n.next = terminal2;
                                    break block2;
                                }
                                n = terminal2;
                                break block2;
                            }
                        }
                        if (name.length() == 0) {
                            ExpressionNode expressionNode;
                            Node node = this.markTextNode(n);
                            if (this.codeCache) {
                                this.start = this.cursor + 1;
                                expressionNode = new CompiledExpressionNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                            } else {
                                this.start = this.cursor + 1;
                                expressionNode = new ExpressionNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                            }
                            node.next = expressionNode;
                            n = expressionNode;
                            break;
                        }
                        if (this.customNodes != null && this.customNodes.containsKey(name)) {
                            Class<? extends Node> customNode = this.customNodes.get(name);
                            try {
                                n = this.markTextNode((Node)n).next = customNode.newInstance();
                                this.markTextNode((Node)n).next.setBegin(this.start);
                                n.setName(name);
                                n.setCStart(this.captureOrbInternal());
                                this.start = this.cursor + 1;
                                n.setCEnd(this.start);
                                n.setEnd(n.getCEnd());
                                n.setContents(ParseTools.subset(this.template, n.getCStart(), n.getCEnd() - n.getCStart() - 1));
                                if (!n.isOpenNode()) break;
                                stack.push(n);
                                break;
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException("unable to instantiate custom node class: " + customNode.getName());
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("unable to instantiate custom node class: " + customNode.getName());
                            }
                        }
                        throw new RuntimeException("unknown token type: " + name);
                    }
                }
                ++this.cursor;
            }
        }
        catch (RuntimeException e) {
            CompileException ce2;
            CompileException ce = new CompileException(e.getMessage(), this.template, this.cursor, e);
            ce.setExpr(this.template);
            if (e instanceof CompileException && (ce2 = (CompileException)e).getCursor() != -1) {
                ce.setCursor(ce2.getCursor());
                if (ce2.getColumn() == -1) {
                    ce.setColumn(ce.getCursor() - this.colStart);
                } else {
                    ce.setColumn(ce2.getColumn());
                }
            }
            ce.setLineNumber(this.line);
            throw ce;
        }
        if (!stack.isEmpty()) {
            CompileException ce = new CompileException("unclosed @" + ((Node)stack.peek()).getName() + "{} block. expected @end{}", this.template, this.cursor);
            ce.setColumn(this.cursor - this.colStart);
            ce.setLineNumber(this.line);
            throw ce;
        }
        if (this.start < this.template.length) {
            n = n.next = new TextNode(this.start, this.template.length);
        }
        n.next = new EndNode();
        n = root;
        while (n.getLength() == 0 && (n = n.getNext()) != null) {
        }
        if (n != null && n.getLength() == this.template.length - 1) {
            if (n instanceof ExpressionNode) {
                return this.codeCache ? new CompiledTerminalExpressionNode(n, this.parserContext) : new TerminalExpressionNode(n);
            }
            return n;
        }
        return root;
    }

    private boolean isNext(char c) {
        return this.cursor != this.length && this.template[this.cursor + 1] == c;
    }

    private int captureOrbToken() {
        int newStart = ++this.cursor;
        while (this.cursor != this.length && ParseTools.isIdentifierPart(this.template[this.cursor])) {
            ++this.cursor;
        }
        if (this.cursor != this.length && this.template[this.cursor] == '{') {
            return newStart;
        }
        return -1;
    }

    private int captureOrbInternal() {
        try {
            ParserContext pCtx = new ParserContext();
            this.start = this.cursor;
            this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.template, this.start, this.length, '{', pCtx);
            this.line += pCtx.getLineCount();
            int ret = this.start + 1;
            this.start = this.cursor + 1;
            return ret;
        }
        catch (CompileException e) {
            e.setLineNumber(this.line);
            e.setColumn(this.cursor - this.colStart + 1);
            throw e;
        }
    }

    private char[] capture() {
        char[] newChar = new char[this.cursor - this.start];
        for (int i = 0; i < newChar.length; ++i) {
            newChar[i] = this.template[i + this.start];
        }
        return newChar;
    }

    private Node markTextNode(Node n) {
        int s;
        int n2 = s = n.getEnd() > this.lastTextRangeEnding ? n.getEnd() : this.lastTextRangeEnding;
        if (s < this.start) {
            this.lastTextRangeEnding = this.start - 1;
            n.next = new TextNode(s, this.lastTextRangeEnding);
            return n.next;
        }
        return n;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public static CompiledTemplate compileTemplate(String template) {
        return new TemplateCompiler((CharSequence)template, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template) {
        return new TemplateCompiler(template, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template) {
        return new TemplateCompiler(template, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(String template, ParserContext context) {
        return new TemplateCompiler((CharSequence)template, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template, ParserContext context) {
        return new TemplateCompiler(template, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template, ParserContext context) {
        return new TemplateCompiler(template, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(String template, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(template, customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(template, customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(template, customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(String template, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new TemplateCompiler(template, customNodes, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new TemplateCompiler(template, customNodes, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new TemplateCompiler(template, customNodes, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(InputStream stream) {
        return TemplateCompiler.compileTemplate(stream, ParserContext.create());
    }

    public static CompiledTemplate compileTemplate(InputStream stream, ParserContext context) {
        return TemplateCompiler.compileTemplate(stream, null, context);
    }

    public static CompiledTemplate compileTemplate(InputStream stream, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(TemplateTools.readStream(stream), customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(InputStream stream, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new TemplateCompiler(TemplateTools.readStream(stream), customNodes, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(File file) {
        return TemplateCompiler.compileTemplate(file, ParserContext.create());
    }

    public static CompiledTemplate compileTemplate(File file, ParserContext context) {
        return TemplateCompiler.compileTemplate(file, null, context);
    }

    public static CompiledTemplate compileTemplate(File file, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(TemplateTools.readInFile(file), customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(File file, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new TemplateCompiler(TemplateTools.readInFile(file), customNodes, true, context).compile();
    }

    public TemplateCompiler(String template) {
        this.template = template.toCharArray();
        this.length = this.template.length;
    }

    public TemplateCompiler(char[] template) {
        this.template = template;
        this.length = template.length;
    }

    public TemplateCompiler(String template, boolean codeCache) {
        this.template = template.toCharArray();
        this.length = this.template.length;
        this.codeCache = codeCache;
    }

    public TemplateCompiler(char[] template, boolean codeCache) {
        this.template = template;
        this.length = template.length;
        this.codeCache = codeCache;
    }

    public TemplateCompiler(char[] template, boolean codeCache, ParserContext context) {
        this.template = template;
        this.length = template.length;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    public TemplateCompiler(CharSequence sequence) {
        this.template = sequence.toString().toCharArray();
        this.length = this.template.length;
    }

    public TemplateCompiler(CharSequence sequence, boolean codeCache) {
        this.template = sequence.toString().toCharArray();
        this.length = this.template.length;
        this.codeCache = codeCache;
    }

    public TemplateCompiler(CharSequence sequence, boolean codeCache, ParserContext context) {
        this.template = sequence.toString().toCharArray();
        this.length = this.template.length;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    public TemplateCompiler(String template, Map<String, Class<? extends Node>> customNodes) {
        this.template = template.toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
    }

    public TemplateCompiler(char[] template, Map<String, Class<? extends Node>> customNodes) {
        this.template = template;
        this.length = template.length;
        this.customNodes = customNodes;
    }

    public TemplateCompiler(CharSequence sequence, Map<String, Class<? extends Node>> customNodes) {
        this.template = sequence.toString().toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
    }

    public TemplateCompiler(String template, Map<String, Class<? extends Node>> customNodes, boolean codeCache) {
        this.template = template.toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
    }

    public TemplateCompiler(char[] template, Map<String, Class<? extends Node>> customNodes, boolean codeCache) {
        this.template = template;
        this.length = template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
    }

    public TemplateCompiler(CharSequence sequence, Map<String, Class<? extends Node>> customNodes, boolean codeCache) {
        this.template = sequence.toString().toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
    }

    public TemplateCompiler(String template, Map<String, Class<? extends Node>> customNodes, boolean codeCache, ParserContext context) {
        this.template = template.toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    public TemplateCompiler(char[] template, Map<String, Class<? extends Node>> customNodes, boolean codeCache, ParserContext context) {
        this.template = template;
        this.length = template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    public TemplateCompiler(CharSequence sequence, Map<String, Class<? extends Node>> customNodes, boolean codeCache, ParserContext context) {
        this.template = sequence.toString().toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    static {
        OPCODES.put("if", 1);
        OPCODES.put("else", 2);
        OPCODES.put("elseif", 2);
        OPCODES.put("end", 10);
        OPCODES.put("foreach", 3);
        OPCODES.put("includeNamed", 51);
        OPCODES.put("include", 50);
        OPCODES.put("comment", 52);
        OPCODES.put("code", 53);
        OPCODES.put("eval", 55);
        OPCODES.put("declare", 54);
        OPCODES.put("stop", 70);
    }
}

