/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.emt4j.agent.org.mvel2.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.CompileException;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.DataConversion;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.ParserContext;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.compiler.ExecutableStatement;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.util.ParseTools;
import org.eclipse.emt4j.emt4j.agent.org.mvel2.util.ReflectionUtil;

public class CollectionParser {
    private char[] property;
    private int cursor;
    private int start;
    private int end;
    private int type;
    public static final int LIST = 0;
    public static final int ARRAY = 1;
    public static final int MAP = 2;
    private Class colType;
    private ParserContext pCtx;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public CollectionParser() {
    }

    public CollectionParser(int type) {
        this.type = type;
    }

    public Object parseCollection(char[] property, int start, int offset, boolean subcompile, ParserContext pCtx) {
        this.property = property;
        this.pCtx = pCtx;
        this.end = start + offset;
        while (start < this.end && ParseTools.isWhitespace(property[start])) {
            ++start;
        }
        this.start = this.cursor = start;
        return this.parseCollection(subcompile);
    }

    public Object parseCollection(char[] property, int start, int offset, boolean subcompile, Class colType, ParserContext pCtx) {
        if (colType != null) {
            this.colType = ParseTools.getBaseComponentType(colType);
        }
        this.property = property;
        this.end = start + offset;
        while (start < this.end && ParseTools.isWhitespace(property[start])) {
            ++start;
        }
        this.start = this.cursor = start;
        this.pCtx = pCtx;
        return this.parseCollection(subcompile);
    }

    private Object parseCollection(boolean subcompile) {
        if (this.end - this.start == 0) {
            if (this.type == 0) {
                return new ArrayList();
            }
            return EMPTY_ARRAY;
        }
        HashMap<String, Object> map = null;
        ArrayList<Object> list = null;
        int st = this.start;
        if (this.type != -1) {
            switch (this.type) {
                case 0: 
                case 1: {
                    list = new ArrayList<Object>();
                    break;
                }
                case 2: {
                    map = new HashMap<String, Object>();
                }
            }
        }
        Object curr = null;
        int newType = -1;
        while (this.cursor < this.end) {
            switch (this.property[this.cursor]) {
                case '{': {
                    if (newType == -1) {
                        newType = 1;
                    }
                }
                case '[': {
                    if (this.cursor > this.start && ParseTools.isIdentifierPart(this.property[this.cursor - 1])) break;
                    if (newType == -1) {
                        newType = 0;
                    }
                    st = this.cursor;
                    this.cursor = ParseTools.balancedCapture(this.property, st, this.end, this.property[st]);
                    Object o = new CollectionParser(newType).parseCollection(this.property, st + 1, this.cursor - st - 1, subcompile, this.colType, this.pCtx);
                    if (this.type == 2) {
                        map.put((String)curr, o);
                    } else {
                        curr = o;
                        list.add(curr);
                    }
                    st = this.cursor = ParseTools.skipWhitespace(this.property, ++this.cursor);
                    if (st < this.end && this.property[this.cursor] == ',') {
                        st = this.cursor + 1;
                        break;
                    }
                    if (this.cursor >= this.end || ParseTools.opLookup(this.property[this.cursor]) != -1) break;
                    throw new CompileException("unterminated collection element", this.property, this.cursor);
                }
                case '(': {
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, this.end, '(');
                    break;
                }
                case '\"': 
                case '\'': {
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, this.end, this.property[this.cursor]);
                    break;
                }
                case ',': {
                    if (this.type != 2) {
                        list.add(new String(this.property, st, this.cursor - st).trim());
                    } else {
                        map.put((String)curr, ParseTools.createStringTrimmed(this.property, st, this.cursor - st));
                    }
                    if (subcompile) {
                        this.subCompile(st, this.cursor - st);
                    }
                    st = this.cursor + 1;
                    break;
                }
                case ':': {
                    if (this.type != 2) {
                        map = new HashMap();
                        this.type = 2;
                    }
                    curr = ParseTools.createStringTrimmed(this.property, st, this.cursor - st);
                    if (subcompile) {
                        this.subCompile(st, this.cursor - st);
                    }
                    st = this.cursor + 1;
                    break;
                }
                case '.': {
                    ++this.cursor;
                    this.cursor = ParseTools.skipWhitespace(this.property, this.cursor);
                    if (this.cursor == this.end || this.property[this.cursor] != '{') break;
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, '{');
                }
            }
            ++this.cursor;
        }
        if (st < this.end && ParseTools.isWhitespace(this.property[st])) {
            st = ParseTools.skipWhitespace(this.property, st);
        }
        if (st < this.end) {
            if (this.cursor < this.end - 1) {
                ++this.cursor;
            }
            if (this.type == 2) {
                map.put((String)curr, ParseTools.createStringTrimmed(this.property, st, this.cursor - st));
            } else {
                if (this.cursor < this.end) {
                    ++this.cursor;
                }
                list.add(ParseTools.createStringTrimmed(this.property, st, this.cursor - st));
            }
            if (subcompile) {
                this.subCompile(st, this.cursor - st);
            }
        }
        switch (this.type) {
            case 2: {
                return map;
            }
            case 1: {
                return list.toArray();
            }
        }
        return list;
    }

    private void subCompile(int start, int offset) {
        if (this.colType == null) {
            ParseTools.subCompileExpression(this.property, start, offset, this.pCtx);
        } else {
            Class r = ((ExecutableStatement)ParseTools.subCompileExpression(this.property, start, offset, this.pCtx)).getKnownEgressType();
            if (!(r == null || ReflectionUtil.isAssignableFrom(this.colType, r) || !this.isStrongType() && DataConversion.canConvert(r, this.colType))) {
                throw new CompileException("expected type: " + this.colType.getName() + "; but found: " + r.getName(), this.property, this.cursor);
            }
        }
    }

    private boolean isStrongType() {
        return this.pCtx != null && this.pCtx.isStrongTyping();
    }

    public int getCursor() {
        return this.cursor;
    }
}

