/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.MethodHandleEncodedValue;
import org.jf.dexlib2.iface.value.MethodTypeEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.util.StringUtils;

public final class EncodedValueUtils {
    public static boolean isDefaultValue(EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 31: {
                return !((BooleanEncodedValue)encodedValue).getValue();
            }
            case 0: {
                return ((ByteEncodedValue)encodedValue).getValue() == 0;
            }
            case 3: {
                return ((CharEncodedValue)encodedValue).getValue() == '\u0000';
            }
            case 17: {
                return ((DoubleEncodedValue)encodedValue).getValue() == 0.0;
            }
            case 16: {
                return ((FloatEncodedValue)encodedValue).getValue() == 0.0f;
            }
            case 4: {
                return ((IntEncodedValue)encodedValue).getValue() == 0;
            }
            case 6: {
                return ((LongEncodedValue)encodedValue).getValue() == 0L;
            }
            case 30: {
                return true;
            }
            case 2: {
                return ((ShortEncodedValue)encodedValue).getValue() == 0;
            }
        }
        return false;
    }

    @Deprecated
    public static void writeEncodedValue(Writer writer, EncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 31: {
                writer.write(Boolean.toString(((BooleanEncodedValue)encodedValue).getValue()));
                break;
            }
            case 0: {
                writer.write(Byte.toString(((ByteEncodedValue)encodedValue).getValue()));
                break;
            }
            case 3: {
                writer.write(Integer.toString(((CharEncodedValue)encodedValue).getValue()));
                break;
            }
            case 2: {
                writer.write(Short.toString(((ShortEncodedValue)encodedValue).getValue()));
                break;
            }
            case 4: {
                writer.write(Integer.toString(((IntEncodedValue)encodedValue).getValue()));
                break;
            }
            case 6: {
                writer.write(Long.toString(((LongEncodedValue)encodedValue).getValue()));
                break;
            }
            case 16: {
                writer.write(Float.toString(((FloatEncodedValue)encodedValue).getValue()));
                break;
            }
            case 17: {
                writer.write(Double.toString(((DoubleEncodedValue)encodedValue).getValue()));
                break;
            }
            case 29: {
                EncodedValueUtils.writeAnnotation(writer, (AnnotationEncodedValue)encodedValue);
                break;
            }
            case 28: {
                EncodedValueUtils.writeArray(writer, (ArrayEncodedValue)encodedValue);
                break;
            }
            case 23: {
                writer.write(34);
                StringUtils.writeEscapedString(writer, ((StringEncodedValue)encodedValue).getValue());
                writer.write(34);
                break;
            }
            case 25: {
                ReferenceUtil.writeFieldDescriptor(writer, ((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                ReferenceUtil.writeFieldDescriptor(writer, ((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                ReferenceUtil.writeMethodDescriptor(writer, ((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                writer.write(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 21: {
                ReferenceUtil.writeMethodProtoDescriptor(writer, ((MethodTypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 22: {
                ReferenceUtil.writeMethodHandle(writer, ((MethodHandleEncodedValue)encodedValue).getValue());
                break;
            }
            case 30: {
                writer.write("null");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown encoded value type");
            }
        }
    }

    private static void writeAnnotation(Writer writer, AnnotationEncodedValue annotation2) throws IOException {
        writer.write("Annotation[");
        writer.write(annotation2.getType());
        Set<? extends AnnotationElement> elements = annotation2.getElements();
        for (AnnotationElement annotationElement : elements) {
            writer.write(", ");
            writer.write(annotationElement.getName());
            writer.write(61);
            EncodedValueUtils.writeEncodedValue(writer, annotationElement.getValue());
        }
        writer.write(93);
    }

    private static void writeArray(Writer writer, ArrayEncodedValue array) throws IOException {
        writer.write("Array[");
        boolean first = true;
        for (EncodedValue encodedValue : array.getValue()) {
            if (first) {
                first = false;
            } else {
                writer.write(", ");
            }
            EncodedValueUtils.writeEncodedValue(writer, encodedValue);
        }
        writer.write(93);
    }

    private EncodedValueUtils() {
    }
}

