/*
 * Decompiled with CFR 0.152.
 */
package ppg.lex;

import java.io.IOException;
import java.io.OutputStream;
import java_cup.runtime.Symbol;
import ppg.lex.LexerResult;

public class Token
implements LexerResult {
    private Symbol symbol;
    private String filename;
    private int lineno;
    private Object value;
    static int lastID;

    public Token(String filename, int lineno, Object value) {
        this(-1, filename, lineno, -1, -1, value);
    }

    public Token(int id, String filename, int lineno, int left, int right, Object value) {
        this.symbol = new Symbol(id, left, right, (Object)this);
        lastID = id;
        this.filename = filename;
        this.lineno = lineno;
        this.value = value;
    }

    public int getCode() {
        return this.symbol.sym;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Object getValue() {
        return this.value;
    }

    public String getID() {
        return Token.toString(this.symbol.sym);
    }

    public static String toString(int type) {
        switch (type) {
            case 2: {
                return "INCLUDE";
            }
            case 39: {
                return "EXTEND";
            }
            case 4: {
                return "DROP";
            }
            case 40: {
                return "OVERRIDE";
            }
            case 5: {
                return "TRANSFER";
            }
            case 22: {
                return "IMPORT";
            }
            case 13: {
                return "CCEQ";
            }
            case 11: {
                return "SEMI";
            }
            case 10: {
                return "COMMA";
            }
            case 18: {
                return "DOT";
            }
            case 12: {
                return "COLON";
            }
            case 6: {
                return "LBRACE";
            }
            case 7: {
                return "RBRACE";
            }
            case 19: {
                return "LBRACK";
            }
            case 20: {
                return "RBRACK";
            }
            case 37: {
                return "ID";
            }
            case 38: {
                return "CODE_STR";
            }
            case 36: {
                return "STRING_CONST";
            }
            case 29: {
                return "WITH";
            }
            case 25: {
                return "PARSER";
            }
            case 27: {
                return "INIT";
            }
            case 31: {
                return "STAR";
            }
            case 14: {
                return "BAR";
            }
            case 28: {
                return "SCAN";
            }
            case 26: {
                return "NON";
            }
            case 23: {
                return "CODE";
            }
            case 33: {
                return "LEFT";
            }
            case 30: {
                return "START";
            }
            case 16: {
                return "NONTERMINAL";
            }
            case 24: {
                return "ACTION";
            }
            case 3: {
                return "TO";
            }
            case 21: {
                return "PACKAGE";
            }
            case 35: {
                return "NONASSOC";
            }
            case 32: {
                return "PRECEDENCE";
            }
            case 17: {
                return "PRECEDENCE";
            }
            case 15: {
                return "TERMINAL";
            }
            case 34: {
                return "RIGHT";
            }
            case 0: {
                return "EOF";
            }
            case 1: {
                return "ERROR";
            }
        }
        System.out.println("Invalid token conversion: " + type);
        System.exit(2);
        return null;
    }

    public String toString() {
        return (String)this.value;
    }

    public void unparse(OutputStream o) {
        if (this.value != null) {
            try {
                o.write((this.filename + ":" + this.lineno + ": " + this.getID() + ": \"" + this.value + "\"").getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public int lineNumber() {
        return this.lineno;
    }

    public int getLineno() {
        return this.lineno;
    }

    public void setLineno(int i) {
        this.lineno = i;
    }
}

