/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.ClassMember;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.SpecialInvokeExpr;
import soot.util.ArraySet;
import soot.util.Chain;

public class Hierarchy {
    protected Map<SootClass, List<SootClass>> classToSubclasses;
    protected Map<SootClass, List<SootClass>> interfaceToSubinterfaces;
    protected Map<SootClass, List<SootClass>> interfaceToSuperinterfaces;
    protected Map<SootClass, List<SootClass>> classToDirSubclasses;
    protected Map<SootClass, List<SootClass>> interfaceToDirSubinterfaces;
    protected Map<SootClass, List<SootClass>> interfaceToDirSuperinterfaces;
    protected Map<SootClass, List<SootClass>> interfaceToDirImplementers;
    final Scene sc = Scene.v();
    final int state = this.sc.getState();

    public Hierarchy() {
        Chain<SootClass> allClasses = this.sc.getClasses();
        int mapSize = allClasses.size() * 2 + 1;
        this.classToSubclasses = new HashMap<SootClass, List<SootClass>>(mapSize, 0.7f);
        this.interfaceToSubinterfaces = new HashMap<SootClass, List<SootClass>>(mapSize, 0.7f);
        this.interfaceToSuperinterfaces = new HashMap<SootClass, List<SootClass>>(mapSize, 0.7f);
        this.classToDirSubclasses = new HashMap<SootClass, List<SootClass>>(mapSize, 0.7f);
        this.interfaceToDirSubinterfaces = new HashMap<SootClass, List<SootClass>>(mapSize, 0.7f);
        this.interfaceToDirSuperinterfaces = new HashMap<SootClass, List<SootClass>>(mapSize, 0.7f);
        this.interfaceToDirImplementers = new HashMap<SootClass, List<SootClass>>(mapSize, 0.7f);
        this.initializeHierarchy(allClasses);
    }

    protected void initializeHierarchy(Chain<SootClass> allClasses) {
        List<SootClass> l;
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1) continue;
            if (c.isInterface()) {
                this.interfaceToDirSubinterfaces.put(c, new ArrayList());
                this.interfaceToDirSuperinterfaces.put(c, new ArrayList());
                this.interfaceToDirImplementers.put(c, new ArrayList());
                continue;
            }
            this.classToDirSubclasses.put(c, new ArrayList());
        }
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1 || !c.hasSuperclass()) continue;
            if (c.isInterface()) {
                List<SootClass> l2 = this.interfaceToDirSuperinterfaces.get(c);
                for (SootClass i : c.getInterfaces()) {
                    if (c.resolvingLevel() < 1) continue;
                    List<SootClass> l3 = this.interfaceToDirSubinterfaces.get(i);
                    if (l3 != null) {
                        l3.add(c);
                    }
                    if (l2 == null) continue;
                    l2.add(i);
                }
                continue;
            }
            l = this.classToDirSubclasses.get(c.getSuperclass());
            if (l != null) {
                l.add(c);
            }
            for (SootClass i : c.getInterfaces()) {
                List<SootClass> l2;
                if (c.resolvingLevel() < 1 || (l2 = this.interfaceToDirImplementers.get(i)) == null) continue;
                l2.add(c);
            }
        }
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1) continue;
            if (c.isInterface()) {
                ArraySet<SootClass> s = new ArraySet<SootClass>();
                for (SootClass c0 : this.interfaceToDirImplementers.get(c)) {
                    if (c.resolvingLevel() < 1) continue;
                    s.addAll(this.getSubclassesOfIncluding(c0));
                }
                this.interfaceToDirImplementers.put(c, new ArrayList(s));
                continue;
            }
            if (!c.hasSuperclass() || (l = this.classToDirSubclasses.get(c)) == null) continue;
            this.classToDirSubclasses.put(c, new ArrayList<SootClass>(l));
        }
    }

    protected void checkState() {
        if (this.state != this.sc.getState()) {
            throw new ConcurrentModificationException("Scene changed for Hierarchy!");
        }
    }

    public List<SootClass> getSubclassesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        List<SootClass> subclasses = this.getSubclassesOf(c);
        ArrayList<SootClass> result = new ArrayList<SootClass>(subclasses.size() + 1);
        result.addAll(subclasses);
        result.add(c);
        return Collections.unmodifiableList(result);
    }

    public List<SootClass> getSubclassesOf(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        List<SootClass> retVal = this.classToSubclasses.get(c);
        if (retVal != null) {
            return retVal;
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        for (SootClass cls : this.classToDirSubclasses.get(c)) {
            if (cls.resolvingLevel() < 1) continue;
            l.addAll(this.getSubclassesOfIncluding(cls));
        }
        l.trimToSize();
        retVal = Collections.unmodifiableList(l);
        this.classToSubclasses.put(c, retVal);
        return retVal;
    }

    public List<SootClass> getSuperclassesOfIncluding(SootClass sootClass) {
        List<SootClass> superclasses = this.getSuperclassesOf(sootClass);
        ArrayList<SootClass> result = new ArrayList<SootClass>(superclasses.size() + 1);
        result.add(sootClass);
        result.addAll(superclasses);
        return Collections.unmodifiableList(result);
    }

    public List<SootClass> getSuperclassesOf(SootClass sootClass) {
        sootClass.checkLevel(1);
        if (sootClass.isInterface()) {
            throw new IllegalArgumentException(sootClass.getName() + " is an interface, but class is expected");
        }
        this.checkState();
        ArrayList<SootClass> superclasses = new ArrayList<SootClass>();
        SootClass current = sootClass;
        while (current.hasSuperclass()) {
            SootClass superclass = current.getSuperclass();
            superclasses.add(superclass);
            current = superclass;
        }
        return Collections.unmodifiableList(superclasses);
    }

    public List<SootClass> getSubinterfacesOfIncluding(SootClass sootClass) {
        List<SootClass> subinterfaces = this.getSubinterfacesOf(sootClass);
        ArrayList<SootClass> result = new ArrayList<SootClass>(subinterfaces.size() + 1);
        result.addAll(subinterfaces);
        result.add(sootClass);
        return Collections.unmodifiableList(result);
    }

    public List<SootClass> getSubinterfacesOf(SootClass sootClass) {
        sootClass.checkLevel(1);
        if (!sootClass.isInterface()) {
            throw new IllegalArgumentException(sootClass.getName() + " is a class, but interface is expected");
        }
        this.checkState();
        List<SootClass> retVal = this.interfaceToSubinterfaces.get(sootClass);
        if (retVal != null) {
            return retVal;
        }
        List<SootClass> directSubInterfaces = this.interfaceToDirSubinterfaces.get(sootClass);
        if (directSubInterfaces == null || directSubInterfaces.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        for (SootClass si : directSubInterfaces) {
            l.addAll(this.getSubinterfacesOfIncluding(si));
        }
        l.trimToSize();
        retVal = Collections.unmodifiableList(l);
        this.interfaceToSubinterfaces.put(sootClass, retVal);
        return retVal;
    }

    public List<SootClass> getSuperinterfacesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        List<SootClass> superinterfaces = this.getSuperinterfacesOf(c);
        ArrayList<SootClass> result = new ArrayList<SootClass>(superinterfaces.size() + 1);
        result.addAll(superinterfaces);
        result.add(c);
        return Collections.unmodifiableList(result);
    }

    public List<SootClass> getSuperinterfacesOf(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        List<SootClass> retVal = this.interfaceToSuperinterfaces.get(c);
        if (retVal != null) {
            return retVal;
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        for (SootClass si : this.interfaceToDirSuperinterfaces.get(c)) {
            l.addAll(this.getSuperinterfacesOfIncluding(si));
        }
        l.trimToSize();
        retVal = Collections.unmodifiableList(l);
        this.interfaceToSuperinterfaces.put(c, retVal);
        return retVal;
    }

    public List<SootClass> getDirectSuperclassesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List<SootClass> getDirectSubclassesOf(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        return Collections.unmodifiableList(this.classToDirSubclasses.get(c));
    }

    public List<SootClass> getDirectSubclassesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        List<SootClass> subclasses = this.classToDirSubclasses.get(c);
        ArrayList<SootClass> l = new ArrayList<SootClass>(subclasses.size() + 1);
        l.addAll(subclasses);
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getDirectSuperinterfacesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List<SootClass> getDirectSubinterfacesOf(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        return Collections.unmodifiableList(this.interfaceToDirSubinterfaces.get(c));
    }

    public List<SootClass> getDirectSubinterfacesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        List<SootClass> subinterfaces = this.interfaceToDirSubinterfaces.get(c);
        ArrayList<SootClass> l = new ArrayList<SootClass>(subinterfaces.size() + 1);
        l.addAll(subinterfaces);
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getDirectImplementersOf(SootClass i) {
        i.checkLevel(1);
        if (!i.isInterface()) {
            throw new RuntimeException("interface needed; got " + i);
        }
        this.checkState();
        return Collections.unmodifiableList(this.interfaceToDirImplementers.get(i));
    }

    public List<SootClass> getImplementersOf(SootClass i) {
        i.checkLevel(1);
        if (!i.isInterface()) {
            throw new RuntimeException("interface needed; got " + i);
        }
        this.checkState();
        ArraySet<SootClass> set = new ArraySet<SootClass>();
        for (SootClass c : this.getSubinterfacesOfIncluding(i)) {
            set.addAll(this.getDirectImplementersOf(c));
        }
        return Collections.unmodifiableList(new ArrayList(set));
    }

    public boolean isClassSubclassOf(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        List<SootClass> parentClasses = this.getSuperclassesOf(child);
        if (parentClasses.contains(possibleParent)) {
            return true;
        }
        for (SootClass sc : parentClasses) {
            if (!sc.isPhantom()) continue;
            return true;
        }
        return false;
    }

    public boolean isClassSubclassOfIncluding(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        List<SootClass> parentClasses = this.getSuperclassesOfIncluding(child);
        if (parentClasses.contains(possibleParent)) {
            return true;
        }
        for (SootClass sc : parentClasses) {
            if (!sc.isPhantom()) continue;
            return true;
        }
        return false;
    }

    public boolean isClassDirectSubclassOf(SootClass c, SootClass c2) {
        throw new RuntimeException("Not implemented yet!");
    }

    public boolean isClassSuperclassOf(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getSubclassesOf(parent).contains(possibleChild);
    }

    public boolean isClassSuperclassOfIncluding(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getSubclassesOfIncluding(parent).contains(possibleChild);
    }

    public boolean isInterfaceSubinterfaceOf(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        return this.getSubinterfacesOf(possibleParent).contains(child);
    }

    public boolean isInterfaceDirectSubinterfaceOf(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        return this.getDirectSubinterfacesOf(possibleParent).contains(child);
    }

    public boolean isInterfaceSuperinterfaceOf(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getSuperinterfacesOf(possibleChild).contains(parent);
    }

    public boolean isInterfaceDirectSuperinterfaceOf(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getDirectSuperinterfacesOf(possibleChild).contains(parent);
    }

    public SootClass getLeastCommonSuperclassOf(SootClass c1, SootClass c2) {
        c1.checkLevel(1);
        c2.checkLevel(1);
        throw new RuntimeException("Not implemented yet!");
    }

    public boolean isVisible(SootClass from, SootClass check) {
        if (check.isPublic()) {
            return true;
        }
        if (check.isProtected() || check.isPrivate()) {
            return false;
        }
        return from.getJavaPackageName().equals(check.getJavaPackageName());
    }

    public boolean isVisible(SootClass from, ClassMember m) {
        from.checkLevel(1);
        SootClass declaringClass = m.getDeclaringClass();
        declaringClass.checkLevel(1);
        if (!this.isVisible(from, declaringClass)) {
            return false;
        }
        if (m.isPublic()) {
            return true;
        }
        if (m.isPrivate()) {
            return from.equals(declaringClass);
        }
        if (m.isProtected()) {
            return this.isClassSubclassOfIncluding(from, declaringClass) || from.getJavaPackageName().equals(declaringClass.getJavaPackageName());
        }
        return from.getJavaPackageName().equals(declaringClass.getJavaPackageName());
    }

    public SootMethod resolveConcreteDispatch(SootClass concreteType, SootMethod m) {
        concreteType.checkLevel(1);
        m.getDeclaringClass().checkLevel(1);
        this.checkState();
        if (concreteType.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        String methodSig = m.getSubSignature();
        for (SootClass c : this.getSuperclassesOfIncluding(concreteType)) {
            SootMethod sm = c.getMethodUnsafe(methodSig);
            if (sm == null || !this.isVisible(c, m)) continue;
            return sm;
        }
        throw new RuntimeException("could not resolve concrete dispatch!\nType: " + concreteType + "\nMethod: " + m);
    }

    public List<SootMethod> resolveConcreteDispatch(List<Type> classes, SootMethod m) {
        m.getDeclaringClass().checkLevel(1);
        this.checkState();
        ArraySet<SootMethod> s = new ArraySet<SootMethod>();
        for (Type cls : classes) {
            if (cls instanceof RefType) {
                s.add(this.resolveConcreteDispatch(((RefType)cls).getSootClass(), m));
                continue;
            }
            if (cls instanceof ArrayType) {
                s.add(this.resolveConcreteDispatch(RefType.v("java.lang.Object").getSootClass(), m));
                continue;
            }
            throw new RuntimeException("Unable to resolve concrete dispatch of type " + cls);
        }
        return Collections.unmodifiableList(new ArrayList(s));
    }

    public List<SootMethod> resolveAbstractDispatch(SootClass c, SootMethod m) {
        Collection<Object> classes;
        c.checkLevel(1);
        m.getDeclaringClass().checkLevel(1);
        this.checkState();
        if (c.isInterface()) {
            classes = new HashSet();
            for (SootClass sootClass : this.getImplementersOf(c)) {
                classes.addAll(this.getSubclassesOfIncluding(sootClass));
            }
        } else {
            classes = this.getSubclassesOfIncluding(c);
        }
        ArraySet<SootMethod> s = new ArraySet<SootMethod>();
        for (SootClass sootClass : classes) {
            if (Modifier.isAbstract(sootClass.getModifiers())) continue;
            s.add(this.resolveConcreteDispatch(sootClass, m));
        }
        return Collections.unmodifiableList(new ArrayList(s));
    }

    public List<SootMethod> resolveAbstractDispatch(List<SootClass> classes, SootMethod m) {
        m.getDeclaringClass().checkLevel(1);
        ArraySet<SootMethod> s = new ArraySet<SootMethod>();
        for (SootClass sootClass : classes) {
            s.addAll(this.resolveAbstractDispatch(sootClass, m));
        }
        return Collections.unmodifiableList(new ArrayList(s));
    }

    public SootMethod resolveSpecialDispatch(SpecialInvokeExpr ie, SootMethod container2) {
        SootClass containerClass = container2.getDeclaringClass();
        containerClass.checkLevel(1);
        SootMethod target = ie.getMethod();
        SootClass targetClass = target.getDeclaringClass();
        targetClass.checkLevel(1);
        if ("<init>".equals(target.getName()) || target.isPrivate()) {
            return target;
        }
        if (this.isClassSubclassOf(targetClass, containerClass)) {
            return this.resolveConcreteDispatch(containerClass, target);
        }
        return target;
    }
}

