/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import soot.JastAddJ.ClassDecl;
import soot.JastAddJ.Constraints;
import soot.JastAddJ.GLBType;
import soot.JastAddJ.InterfaceDecl;
import soot.JastAddJ.LUBType;
import soot.JastAddJ.ParInterfaceDecl;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.TypeVariable;

public class GLBTypeFactory {
    public static TypeDecl glb(ArrayList typeList) {
        TypeDecl retType = ((TypeDecl)typeList.get(0)).unknownType();
        TypeDecl cls = GLBTypeFactory.mostSpecificSuperClass(typeList);
        if (cls != null) {
            ArrayList intersectInterfaceList = new ArrayList();
            ArrayList allInterfaceList = new ArrayList();
            for (TypeDecl typeDecl : typeList) {
                GLBTypeFactory.addInterfaces(intersectInterfaceList, allInterfaceList, typeDecl);
            }
            GLBTypeFactory.greatestLowerBounds(intersectInterfaceList);
            if (GLBTypeFactory.checkInterfaceCompatibility(allInterfaceList) && GLBTypeFactory.checkClassInterfaceCompatibility(cls, intersectInterfaceList)) {
                GLBTypeFactory.greatestLowerBounds(typeList);
                retType = typeList.size() == 1 ? (TypeDecl)typeList.iterator().next() : retType.lookupGLBType(typeList);
            }
        }
        return retType;
    }

    private static void addInterfaces(ArrayList intersectInterfaceList, ArrayList allInterfaceList, TypeDecl typeDecl) {
        if (typeDecl.isInterfaceDecl()) {
            intersectInterfaceList.add((InterfaceDecl)typeDecl);
            allInterfaceList.add((InterfaceDecl)typeDecl);
        } else if (typeDecl instanceof TypeVariable) {
            TypeVariable varTD = (TypeVariable)typeDecl;
            intersectInterfaceList.add(varTD.toInterface());
            allInterfaceList.addAll(varTD.implementedInterfaces());
        } else if (typeDecl instanceof LUBType) {
            allInterfaceList.addAll(typeDecl.implementedInterfaces());
        } else if (typeDecl instanceof GLBType) {
            allInterfaceList.addAll(typeDecl.implementedInterfaces());
        }
    }

    public static final TypeDecl mostSpecificSuperClass(ArrayList types) {
        ArrayList<TypeDecl> csList = new ArrayList<TypeDecl>();
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            csList.add(GLBTypeFactory.mostSpecificSuperClass((TypeDecl)iter.next()));
        }
        GLBTypeFactory.greatestLowerBounds(csList);
        if (csList.size() == 1) {
            return (TypeDecl)csList.get(0);
        }
        return null;
    }

    private static final TypeDecl mostSpecificSuperClass(TypeDecl t) {
        HashSet superTypes = new HashSet();
        GLBTypeFactory.addSuperClasses(t, superTypes);
        if (superTypes.isEmpty()) {
            return t.typeObject();
        }
        ArrayList result = new ArrayList(superTypes.size());
        result.addAll(superTypes);
        GLBTypeFactory.greatestLowerBounds(result);
        if (result.size() == 1) {
            return (TypeDecl)result.get(0);
        }
        return t.typeObject();
    }

    private static final void addSuperClasses(TypeDecl t, HashSet result) {
        if (t == null) {
            return;
        }
        if (t.isClassDecl() && !result.contains(t)) {
            result.add((ClassDecl)t);
        } else if (t.isTypeVariable()) {
            TypeVariable var = (TypeVariable)t;
            for (int i = 0; i < var.getNumTypeBound(); ++i) {
                GLBTypeFactory.addSuperClasses(var.getTypeBound(i).type(), result);
            }
        } else if (t instanceof LUBType || t instanceof GLBType) {
            result.add(t);
        } else if (t.isInterfaceDecl()) {
            result.add((ClassDecl)t.typeObject());
        }
    }

    private static boolean checkInterfaceCompatibility(ArrayList ifaceList) {
        for (int i = 0; i < ifaceList.size(); ++i) {
            HashSet superISet_i = Constraints.parameterizedSupertypes((TypeDecl)ifaceList.get(i));
            for (InterfaceDecl superIface_i : superISet_i) {
                if (!(superIface_i instanceof ParInterfaceDecl)) continue;
                ParInterfaceDecl pi = (ParInterfaceDecl)superIface_i;
                for (int j = i + 1; j < ifaceList.size(); ++j) {
                    HashSet superISet_j = Constraints.parameterizedSupertypes((TypeDecl)ifaceList.get(j));
                    for (InterfaceDecl superIface_j : superISet_j) {
                        ParInterfaceDecl pj;
                        if (!(superIface_j instanceof ParInterfaceDecl) || pi == (pj = (ParInterfaceDecl)superIface_j) || pi.genericDecl() != pj.genericDecl() || pi.sameArgument(pj)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean checkClassInterfaceCompatibility(TypeDecl cls, ArrayList ifaceList) {
        HashSet implementedInterfaces = cls.implementedInterfaces();
        for (InterfaceDecl impInterface : implementedInterfaces) {
            if (!(impInterface instanceof ParInterfaceDecl)) continue;
            ParInterfaceDecl impParIface = (ParInterfaceDecl)impInterface;
            for (InterfaceDecl iface : ifaceList) {
                ParInterfaceDecl parIface;
                if (!(iface instanceof ParInterfaceDecl) || (parIface = (ParInterfaceDecl)iface) == impParIface || parIface.genericDecl() != impParIface.genericDecl() || parIface.sameArgument(impParIface)) continue;
                return false;
            }
        }
        return true;
    }

    public static final void greatestLowerBounds(ArrayList types) {
        for (int i = 0; i < types.size(); ++i) {
            TypeDecl U = (TypeDecl)types.get(i);
            for (int j = i + 1; j < types.size(); ++j) {
                TypeDecl V9 = (TypeDecl)types.get(j);
                if (U == null || V9 == null) continue;
                if (U.instanceOf(V9)) {
                    types.set(j, null);
                    continue;
                }
                if (!V9.instanceOf(U)) continue;
                types.set(i, null);
            }
        }
        GLBTypeFactory.removeNullValues(types);
    }

    public static final void removeNullValues(ArrayList types) {
        ArrayList<Object> filter = new ArrayList<Object>(1);
        filter.add(null);
        types.removeAll(filter);
    }
}

