/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import soot.Unit;
import soot.util.Chain;

public class PatchingChain<E extends Unit>
extends AbstractCollection<E>
implements Chain<E> {
    protected final Chain<E> innerChain;

    public PatchingChain(Chain<E> aChain) {
        this.innerChain = aChain;
    }

    public Chain<E> getNonPatchingChain() {
        return this.innerChain;
    }

    @Override
    public boolean add(E o) {
        return this.innerChain.add(o);
    }

    @Override
    public void swapWith(E out, E in) {
        this.innerChain.swapWith(out, in);
        out.redirectJumpsToThisTo((Unit)in);
    }

    @Override
    public void insertAfter(E toInsert, E point) {
        this.innerChain.insertAfter(toInsert, point);
    }

    @Override
    public void insertAfter(List<E> toInsert, E point) {
        this.innerChain.insertAfter(toInsert, point);
    }

    @Override
    public void insertAfter(Chain<E> toInsert, E point) {
        this.innerChain.insertAfter(toInsert, point);
    }

    @Override
    public void insertAfter(Collection<? extends E> toInsert, E point) {
        this.innerChain.insertAfter(toInsert, (E)point);
    }

    @Override
    public void insertBefore(List<E> toInsert, E point) {
        if (!toInsert.isEmpty()) {
            Object previousPoint = point;
            ListIterator<E> it = toInsert.listIterator(toInsert.size());
            while (it.hasPrevious()) {
                Unit o = (Unit)it.previous();
                this.insertBeforeNoRedirect(o, previousPoint);
                previousPoint = o;
            }
            point.redirectJumpsToThisTo((Unit)toInsert.get(0));
        }
    }

    @Override
    public void insertBefore(Chain<E> toInsert, E point) {
        if (!toInsert.isEmpty()) {
            Object previousPoint = point;
            Unit o = (Unit)toInsert.getLast();
            while (o != null) {
                this.insertBeforeNoRedirect(o, previousPoint);
                previousPoint = o;
                o = toInsert.getPredOf(o);
            }
            point.redirectJumpsToThisTo((Unit)toInsert.getFirst());
        }
    }

    @Override
    public void insertBefore(E toInsert, E point) {
        point.redirectJumpsToThisTo((Unit)toInsert);
        this.innerChain.insertBefore(toInsert, point);
    }

    @Override
    public void insertBefore(Collection<? extends E> toInsert, E point) {
        if (toInsert instanceof Chain) {
            Chain temp = (Chain)toInsert;
            this.insertBefore((E)temp, point);
        } else if (toInsert instanceof List) {
            List temp = (List)toInsert;
            this.insertBefore((E)temp, point);
        } else {
            this.insertBefore((E)new ArrayList<E>(toInsert), point);
        }
    }

    public void insertBeforeNoRedirect(E toInsert, E point) {
        this.innerChain.insertBefore(toInsert, point);
    }

    public void insertBeforeNoRedirect(List<E> toInsert, E point) {
        if (!toInsert.isEmpty()) {
            Object previousPoint = point;
            ListIterator<E> it = toInsert.listIterator(toInsert.size());
            while (it.hasPrevious()) {
                Unit o = (Unit)it.previous();
                this.insertBeforeNoRedirect(o, previousPoint);
                previousPoint = o;
            }
        }
    }

    @Override
    public boolean follows(E a, E b) {
        return this.innerChain.follows(a, b);
    }

    @Override
    public boolean remove(Object obj) {
        if (this.contains(obj)) {
            Unit objCast = (Unit)obj;
            PatchingChain.patchBeforeRemoval(this.innerChain, objCast);
            return this.innerChain.remove(objCast);
        }
        return false;
    }

    protected static <E extends Unit> void patchBeforeRemoval(Chain<E> chain, E removing) {
        Unit successor = (Unit)chain.getSuccOf(removing);
        if (successor == null) {
            successor = (Unit)chain.getPredOf(removing);
        }
        removing.redirectJumpsToThisTo(successor);
    }

    @Override
    public boolean contains(Object u) {
        return this.innerChain.contains(u);
    }

    @Override
    public void addFirst(E u) {
        this.innerChain.addFirst(u);
    }

    @Override
    public void addLast(E u) {
        this.innerChain.addLast(u);
    }

    @Override
    public void removeFirst() {
        this.remove(this.innerChain.getFirst());
    }

    @Override
    public void removeLast() {
        this.remove(this.innerChain.getLast());
    }

    @Override
    public E getFirst() {
        return (E)((Unit)this.innerChain.getFirst());
    }

    @Override
    public E getLast() {
        return (E)((Unit)this.innerChain.getLast());
    }

    @Override
    public E getSuccOf(E point) {
        return (E)((Unit)this.innerChain.getSuccOf(point));
    }

    @Override
    public E getPredOf(E point) {
        return (E)((Unit)this.innerChain.getPredOf(point));
    }

    @Override
    public int size() {
        return this.innerChain.size();
    }

    @Override
    public long getModificationCount() {
        return this.innerChain.getModificationCount();
    }

    @Override
    public Collection<E> getElementsUnsorted() {
        return this.innerChain.getElementsUnsorted();
    }

    @Override
    public Iterator<E> snapshotIterator() {
        return this.innerChain.snapshotIterator();
    }

    @Override
    public Iterator<E> iterator() {
        return new PatchingIterator(this.innerChain);
    }

    @Override
    public Iterator<E> iterator(E u) {
        return new PatchingIterator(this, this.innerChain, u);
    }

    @Override
    public Iterator<E> iterator(E head, E tail) {
        return new PatchingIterator(this, this.innerChain, head, tail);
    }

    protected class PatchingIterator
    implements Iterator<E> {
        protected final Chain<E> innerChain;
        protected final Iterator<E> innerIterator;
        protected E lastObject;
        protected boolean state = false;

        protected PatchingIterator(Chain<E> innerChain) {
            this.innerChain = innerChain;
            this.innerIterator = innerChain.iterator();
        }

        protected PatchingIterator(Chain<E> innerChain, E u) {
            this.innerChain = innerChain;
            this.innerIterator = innerChain.iterator(u);
        }

        protected PatchingIterator(Chain<E> innerChain, E head, E tail) {
            this.innerChain = innerChain;
            this.innerIterator = innerChain.iterator(head, tail);
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public E next() {
            this.lastObject = (Unit)this.innerIterator.next();
            this.state = true;
            return this.lastObject;
        }

        @Override
        public void remove() {
            if (!this.state) {
                throw new IllegalStateException("remove called before first next() call");
            }
            this.state = false;
            PatchingChain.patchBeforeRemoval(this.innerChain, this.lastObject);
            this.innerIterator.remove();
        }
    }
}

