/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emt4j.emt4j.agent.org.objectweb.asm.AnnotationVisitor;
import org.eclipse.emt4j.emt4j.agent.org.objectweb.asm.Attribute;
import org.eclipse.emt4j.emt4j.agent.org.objectweb.asm.ClassVisitor;
import org.eclipse.emt4j.emt4j.agent.org.objectweb.asm.FieldVisitor;
import org.eclipse.emt4j.emt4j.agent.org.objectweb.asm.MethodVisitor;
import org.eclipse.emt4j.emt4j.agent.org.objectweb.asm.ModuleVisitor;
import soot.ModuleRefType;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootModuleInfo;
import soot.SootModuleResolver;
import soot.SootResolver;
import soot.Type;
import soot.asm.AsmUtil;
import soot.asm.FieldBuilder;
import soot.asm.MethodBuilder;
import soot.asm.SootModuleInfoBuilder;
import soot.asm.TagBuilder;
import soot.options.Options;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.InnerClassTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.StringConstantValueTag;

public class SootClassBuilder
extends ClassVisitor {
    protected final SootClass klass;
    protected final Set<Type> deps;
    protected TagBuilder tb;

    protected SootClassBuilder(SootClass klass) {
        super(589824);
        this.klass = klass;
        this.deps = new HashSet<Type>();
    }

    private TagBuilder getTagBuilder() {
        TagBuilder t = this.tb;
        if (t == null) {
            t = this.tb = new TagBuilder(this.klass, this);
        }
        return t;
    }

    protected SootClass getKlass() {
        return this.klass;
    }

    protected void addDep(String s) {
        this.addDep(this.makeRefType(AsmUtil.baseTypeName(s)));
    }

    protected void addDep(Type s) {
        this.deps.add(s);
    }

    @Override
    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        this.setJavaVersion(version2);
        if (access != 32768 && ModuleUtil.module_mode()) {
            SootModuleInfo moduleInfo = (SootModuleInfo)SootModuleResolver.v().makeClassRef("module-info", Optional.fromNullable(this.klass.moduleName));
            this.klass.setModuleInformation(moduleInfo);
        }
        if (!(name = AsmUtil.toQualifiedName(name)).equals(this.klass.getName()) && Options.v().verbose()) {
            System.err.println("Class names not equal! " + name + " != " + this.klass.getName());
        }
        this.klass.setModifiers(SootClassBuilder.filterASMFlags(access) & 0xFFFFFFDF);
        if (superName != null) {
            superName = AsmUtil.toQualifiedName(superName);
            this.addDep(this.makeRefType(superName));
            SootClass superClass = this.makeClassRef(superName);
            this.klass.setSuperclass(superClass);
        }
        for (String intrf : interfaces) {
            intrf = AsmUtil.toQualifiedName(intrf);
            this.addDep(this.makeRefType(intrf));
            SootClass interfaceClass = this.makeClassRef(intrf);
            interfaceClass.setModifiers(interfaceClass.getModifiers() | 0x200);
            this.klass.addInterface(interfaceClass);
        }
        if (signature != null) {
            this.klass.addTag(new SignatureTag(signature));
        }
    }

    private void setJavaVersion(int version2) {
        Options opts = Options.v();
        if (opts.derive_java_version()) {
            opts.set_java_version(Math.max(opts.java_version(), AsmUtil.byteCodeToJavaVersion(version2)));
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Type type = AsmUtil.toJimpleType(desc, Optional.fromNullable(this.klass.moduleName));
        this.addDep(type);
        SootField field = Scene.v().makeSootField(name, type, SootClassBuilder.filterASMFlags(access));
        ConstantValueTag tag = value instanceof Integer ? new IntegerConstantValueTag((Integer)value) : (value instanceof Float ? new FloatConstantValueTag(((Float)value).floatValue()) : (value instanceof Long ? new LongConstantValueTag((Long)value) : (value instanceof Double ? new DoubleConstantValueTag((Double)value) : (value instanceof String ? new StringConstantValueTag(value.toString()) : null))));
        if (tag != null) {
            field.addTag(tag);
        }
        if (signature != null) {
            field.addTag(new SignatureTag(signature));
        }
        return new FieldBuilder(this.klass.getOrAddField(field), this);
    }

    public static int filterASMFlags(int access) {
        return access & 0xFFFDFFFF & 0xFFFEFFFF;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        List<SootClass> thrownExceptions;
        if (exceptions == null || exceptions.length == 0) {
            thrownExceptions = Collections.emptyList();
        } else {
            int len = exceptions.length;
            thrownExceptions = new ArrayList(len);
            for (int i = 0; i != len; ++i) {
                String ex = AsmUtil.toQualifiedName(exceptions[i]);
                this.addDep(this.makeRefType(ex));
                thrownExceptions.add(this.makeClassRef(ex));
            }
        }
        List<Type> sigTypes = AsmUtil.toJimpleDesc(desc, Optional.fromNullable(this.klass.moduleName));
        for (Type type : sigTypes) {
            this.addDep(type);
        }
        SootMethod method = Scene.v().makeSootMethod(name, sigTypes, sigTypes.remove(sigTypes.size() - 1), SootClassBuilder.filterASMFlags(access), thrownExceptions);
        if (signature != null) {
            method.addTag(new SignatureTag(signature));
        }
        return this.createMethodBuilder(this.klass.getOrAddMethod(method), desc, exceptions);
    }

    protected MethodVisitor createMethodBuilder(SootMethod sootMethod, String desc, String[] exceptions) {
        return new MethodBuilder(sootMethod, this, desc, exceptions);
    }

    @Override
    public void visitSource(String source, String debug) {
        if (source != null) {
            this.klass.addTag(new SourceFileTag(source));
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.klass.addTag(new InnerClassTag(name, outerName, innerName, access));
        if (!(this.klass instanceof SootModuleInfo)) {
            this.deps.add(this.makeRefType(AsmUtil.toQualifiedName(name)));
        }
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        if (name != null) {
            this.klass.addTag(new EnclosingMethodTag(owner, name, desc));
        }
        owner = AsmUtil.toQualifiedName(owner);
        this.deps.add(this.makeRefType(owner));
        this.klass.setOuterClass(this.makeClassRef(owner));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.getTagBuilder().visitAnnotation(desc, visible);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.getTagBuilder().visitAttribute(attr);
    }

    @Override
    public ModuleVisitor visitModule(String name, int access, String version2) {
        return new SootModuleInfoBuilder(name, (SootModuleInfo)this.klass, this);
    }

    private SootClass makeClassRef(String className) {
        if (ModuleUtil.module_mode()) {
            return SootModuleResolver.v().makeClassRef(className, Optional.fromNullable(this.klass.moduleName));
        }
        return SootResolver.v().makeClassRef(className);
    }

    private RefType makeRefType(String className) {
        if (ModuleUtil.module_mode()) {
            return ModuleRefType.v(className, Optional.fromNullable(this.klass.moduleName));
        }
        return RefType.v(className);
    }
}

