/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.util.ArrayList;
import soot.Local;
import soot.Unit;
import soot.ValueBox;
import soot.asm.AsmMethodSource;
import soot.asm.AsmUtil;
import soot.asm.Operand;
import soot.asm.UnitContainer;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.Jimple;

final class StackFrame {
    private Operand[] out;
    private Local[] inStackLocals;
    private ValueBox[] boxes;
    private ArrayList<Operand[]> in;
    private final AsmMethodSource src;

    StackFrame(AsmMethodSource src) {
        this.src = src;
    }

    Operand[] out() {
        return this.out;
    }

    void in(Operand ... oprs) {
        ArrayList<Object> in = this.in;
        if (in == null) {
            in = this.in = new ArrayList(1);
        } else {
            in.clear();
        }
        in.add(oprs);
        this.inStackLocals = new Local[oprs.length];
    }

    void boxes(ValueBox ... boxes) {
        this.boxes = boxes;
    }

    void out(Operand ... oprs) {
        this.out = oprs;
    }

    void mergeIn(Operand ... oprs) {
        ArrayList<Operand[]> in = this.in;
        if (in.get(0).length != oprs.length) {
            throw new IllegalArgumentException("Invalid in operands length!");
        }
        int nrIn = in.size();
        boolean diff = false;
        for (int i = 0; i != oprs.length; ++i) {
            DefinitionStmt as;
            Operand newOp = oprs[i];
            diff = true;
            Local stack = this.inStackLocals[i];
            if (stack != null) {
                if (newOp.stack == null) {
                    newOp.stack = stack;
                    AssignStmt as2 = Jimple.v().newAssignStmt(stack, newOp.value);
                    this.src.setUnit(newOp.insn, as2);
                    newOp.updateBoxes();
                    continue;
                }
                Object prev = this.src.getUnit(newOp.insn);
                boolean merge = true;
                if (prev instanceof UnitContainer) {
                    for (Unit t : ((UnitContainer)prev).units) {
                        if (!AsmUtil.alreadyExists(t, stack, newOp.stackOrValue())) continue;
                        merge = false;
                        break;
                    }
                } else if (AsmUtil.alreadyExists(prev, stack, newOp.stackOrValue())) {
                    merge = false;
                }
                if (!merge) continue;
                as = Jimple.v().newAssignStmt(stack, newOp.stackOrValue());
                this.src.mergeUnits(newOp.insn, as);
                newOp.addBox(as.getRightOpBox());
                continue;
            }
            for (int j = 0; j != nrIn && (stack = in.get((int)j)[i].stack) == null; ++j) {
            }
            if (stack == null && (stack = newOp.stack) == null) {
                stack = this.src.newStackLocal();
            }
            ValueBox box = this.boxes == null ? null : this.boxes[i];
            for (int j = 0; j != nrIn; ++j) {
                Operand prevOp = in.get(j)[i];
                if (prevOp.stack == stack) continue;
                prevOp.removeBox(box);
                if (prevOp.stack == null) {
                    prevOp.stack = stack;
                    AssignStmt as3 = Jimple.v().newAssignStmt(stack, prevOp.value);
                    this.src.setUnit(prevOp.insn, as3);
                } else {
                    Object u = this.src.getUnit(prevOp.insn);
                    DefinitionStmt as4 = (DefinitionStmt)(u instanceof UnitContainer ? ((UnitContainer)u).getFirstUnit() : u);
                    ValueBox lvb = as4.getLeftOpBox();
                    assert (lvb.getValue() == prevOp.stack) : "Invalid stack local!";
                    lvb.setValue(stack);
                    prevOp.stack = stack;
                }
                prevOp.updateBoxes();
            }
            if (newOp.stack != stack) {
                if (newOp.stack == null) {
                    newOp.stack = stack;
                    AssignStmt as5 = Jimple.v().newAssignStmt(stack, newOp.value);
                    this.src.setUnit(newOp.insn, as5);
                } else {
                    Object u = this.src.getUnit(newOp.insn);
                    as = (DefinitionStmt)(u instanceof UnitContainer ? ((UnitContainer)u).getFirstUnit() : u);
                    ValueBox lvb = as.getLeftOpBox();
                    assert (lvb.getValue() == newOp.stack) : "Invalid stack local!";
                    lvb.setValue(stack);
                    newOp.stack = stack;
                }
                newOp.updateBoxes();
            }
            if (box != null) {
                box.setValue(stack);
            }
            this.inStackLocals[i] = stack;
        }
        if (diff) {
            in.add(oprs);
        }
    }
}

