/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.lang.reflect.Field;
import org.eclipse.emt4j.emt4j.agent.org.objectweb.asm.AnnotationVisitor;
import org.eclipse.emt4j.emt4j.agent.org.objectweb.asm.Attribute;
import soot.asm.AnnotationElemBuilder;
import soot.asm.AsmUtil;
import soot.asm.SootClassBuilder;
import soot.tagkit.AnnotationTag;
import soot.tagkit.GenericAttribute;
import soot.tagkit.Host;
import soot.tagkit.VisibilityAnnotationTag;

final class TagBuilder {
    private VisibilityAnnotationTag invisibleTag;
    private VisibilityAnnotationTag visibleTag;
    private final Host host;
    private final SootClassBuilder scb;

    TagBuilder(Host host, SootClassBuilder scb) {
        this.host = host;
        this.scb = scb;
    }

    public AnnotationVisitor visitAnnotation(final String desc, boolean visible) {
        VisibilityAnnotationTag tag;
        if (visible) {
            tag = this.visibleTag;
            if (tag == null) {
                this.visibleTag = tag = new VisibilityAnnotationTag(0);
                this.host.addTag(tag);
            }
        } else {
            tag = this.invisibleTag;
            if (tag == null) {
                this.invisibleTag = tag = new VisibilityAnnotationTag(1);
                this.host.addTag(tag);
            }
        }
        this.scb.addDep(AsmUtil.toQualifiedName(desc.substring(1, desc.length() - 1)));
        final VisibilityAnnotationTag _tag = tag;
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                _tag.addAnnotation(new AnnotationTag(desc, this.elems));
            }
        };
    }

    public void visitAttribute(Attribute attr) {
        byte[] value = null;
        try {
            Field fld = Attribute.class.getDeclaredField("content");
            fld.setAccessible(true);
            value = (byte[])fld.get(attr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.host.addTag(new GenericAttribute(attr.type, value));
    }
}

