/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import org.jf.dexlib2.iface.reference.StringReference;
import soot.dexpler.DexBody;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.StringConstant;

public class ConstStringInstruction
extends DexlibAbstractInstruction {
    public ConstStringInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        String s;
        ReferenceInstruction i;
        int dest = ((OneRegisterInstruction)this.instruction).getRegisterA();
        if (this.instruction instanceof Instruction21c) {
            i = (Instruction21c)this.instruction;
            s = ((StringReference)i.getReference()).getString();
        } else if (this.instruction instanceof Instruction31c) {
            i = (Instruction31c)this.instruction;
            s = ((StringReference)i.getReference()).getString();
        } else {
            throw new IllegalArgumentException("Expected Instruction21c or Instruction31c but got neither.");
        }
        StringConstant sc = StringConstant.v(s);
        AssignStmt assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), sc);
        this.setUnit(assign);
        this.addTags(assign);
        body.add(assign);
    }

    @Override
    boolean overridesRegister(int register) {
        OneRegisterInstruction i = (OneRegisterInstruction)this.instruction;
        int dest = i.getRegisterA();
        return register == dest;
    }
}

