/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.DynamicInvokeInst;
import soot.jimple.Constant;
import soot.jimple.ConvertToBaf;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.ExprSwitch;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.MethodHandle;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public class JDynamicInvokeExpr
extends AbstractInvokeExpr
implements DynamicInvokeExpr,
ConvertToBaf {
    protected final SootMethodRef bsmRef;
    protected final ValueBox[] bsmArgBoxes;
    protected final int tag;

    public JDynamicInvokeExpr(SootMethodRef bootstrapMethodRef, List<? extends Value> bootstrapArgs, SootMethodRef methodRef, int tag, List<? extends Value> methodArgs) {
        super(methodRef, new ValueBox[methodArgs.size()]);
        Value v;
        if (!methodRef.getSignature().startsWith("<soot.dummy.InvokeDynamic: ")) {
            throw new IllegalArgumentException("Receiver type of JDynamicInvokeExpr must be soot.dummy.InvokeDynamic!");
        }
        this.bsmRef = bootstrapMethodRef;
        this.bsmArgBoxes = new ValueBox[bootstrapArgs.size()];
        this.tag = tag;
        Jimple jimp = Jimple.v();
        ListIterator<? extends Value> it = bootstrapArgs.listIterator();
        while (it.hasNext()) {
            v = it.next();
            if (!(v instanceof Constant)) {
                throw new IllegalArgumentException("Bootstrap arg must be a Constant: " + v);
            }
            this.bsmArgBoxes[it.previousIndex()] = jimp.newImmediateBox(v);
        }
        it = methodArgs.listIterator();
        while (it.hasNext()) {
            v = it.next();
            this.argBoxes[it.previousIndex()] = jimp.newImmediateBox(v);
        }
    }

    public JDynamicInvokeExpr(SootMethodRef bootstrapMethodRef, List<? extends Value> bootstrapArgs, SootMethodRef methodRef, List<? extends Value> methodArgs) {
        this(bootstrapMethodRef, bootstrapArgs, methodRef, MethodHandle.Kind.REF_INVOKE_STATIC.getValue(), methodArgs);
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedBsmArgs = new ArrayList<Value>(this.bsmArgBoxes.length);
        for (ValueBox box : this.bsmArgBoxes) {
            clonedBsmArgs.add(box.getValue());
        }
        int count = this.getArgCount();
        ArrayList<Value> clonedArgs = new ArrayList<Value>(count);
        for (int i = 0; i < count; ++i) {
            clonedArgs.add(Jimple.cloneIfNecessary(this.getArg(i)));
        }
        return new JDynamicInvokeExpr(this.bsmRef, clonedBsmArgs, this.methodRef, this.tag, clonedArgs);
    }

    @Override
    public int getBootstrapArgCount() {
        return this.bsmArgBoxes.length;
    }

    @Override
    public Value getBootstrapArg(int index) {
        return this.bsmArgBoxes[index].getValue();
    }

    @Override
    public List<Value> getBootstrapArgs() {
        ArrayList<Value> l = new ArrayList<Value>();
        for (ValueBox element : this.bsmArgBoxes) {
            l.add(element.getValue());
        }
        return l;
    }

    @Override
    public SootMethodRef getBootstrapMethodRef() {
        return this.bsmRef;
    }

    public SootMethod getBootstrapMethod() {
        return this.bsmRef.resolve();
    }

    @Override
    public int getHandleTag() {
        return this.tag;
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseDynamicInvokeExpr(this);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof JDynamicInvokeExpr) {
            JDynamicInvokeExpr ie = (JDynamicInvokeExpr)o;
            if (!((this.argBoxes == null ? 0 : this.argBoxes.length) == (ie.argBoxes == null ? 0 : ie.argBoxes.length) && this.bsmArgBoxes.length == ie.bsmArgBoxes.length && this.getMethod().equals(ie.getMethod()) && this.methodRef.equals(ie.methodRef) && this.bsmRef.equals(ie.bsmRef))) {
                return false;
            }
            int i = 0;
            for (ValueBox element : this.bsmArgBoxes) {
                if (!element.getValue().equivTo(ie.getBootstrapArg(i))) {
                    return false;
                }
                ++i;
            }
            if (this.argBoxes != null) {
                i = 0;
                for (ValueBox element : this.argBoxes) {
                    if (!element.getValue().equivTo(ie.getArg(i))) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getBootstrapMethod().equivHashCode() * this.getMethod().equivHashCode() * 17;
    }

    public String toString() {
        int i;
        int e;
        StringBuilder buf = new StringBuilder("dynamicinvoke \"");
        buf.append(this.methodRef.name());
        buf.append("\" <");
        buf.append(SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()));
        buf.append(">(");
        if (this.argBoxes != null) {
            e = this.argBoxes.length;
            for (i = 0; i < e; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(this.argBoxes[i].getValue().toString());
            }
        }
        buf.append(") ");
        buf.append(this.bsmRef.getSignature());
        buf.append('(');
        e = this.bsmArgBoxes.length;
        for (i = 0; i < e; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.bsmArgBoxes[i].getValue().toString());
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        int i;
        int e;
        up.literal("dynamicinvoke \"" + this.methodRef.name() + "\" <" + SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()) + ">(");
        if (this.argBoxes != null) {
            e = this.argBoxes.length;
            for (i = 0; i < e; ++i) {
                if (i != 0) {
                    up.literal(", ");
                }
                this.argBoxes[i].toString(up);
            }
        }
        up.literal(") ");
        up.methodRef(this.bsmRef);
        up.literal("(");
        e = this.bsmArgBoxes.length;
        for (i = 0; i < e; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.bsmArgBoxes[i].toString(up);
        }
        up.literal(")");
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        if (this.argBoxes != null) {
            for (ValueBox element : this.argBoxes) {
                ((ConvertToBaf)((Object)element.getValue())).convertToBaf(context, out);
            }
        }
        ArrayList<Value> bsmArgs = new ArrayList<Value>();
        for (ValueBox argBox : this.bsmArgBoxes) {
            bsmArgs.add(argBox.getValue());
        }
        DynamicInvokeInst u = Baf.v().newDynamicInvokeInst(this.bsmRef, bsmArgs, this.methodRef, this.tag);
        u.addAllTagsOf(context.getCurrentUnit());
        out.add(u);
    }
}

