/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand;

import java.util.HashSet;
import java.util.Set;
import soot.PointsToSet;
import soot.Type;
import soot.jimple.ClassConstant;
import soot.jimple.spark.ondemand.AllocAndContext;
import soot.jimple.spark.ondemand.WrappedPointsToSet;
import soot.jimple.spark.ondemand.genericutil.ArraySet;
import soot.jimple.spark.ondemand.genericutil.ImmutableStack;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.StringConstantNode;
import soot.jimple.spark.sets.EqualsSupportingPointsToSet;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;

public final class AllocAndContextSet
extends ArraySet<AllocAndContext>
implements EqualsSupportingPointsToSet {
    @Override
    public boolean hasNonEmptyIntersection(PointsToSet other) {
        if (other instanceof AllocAndContextSet) {
            return this.nonEmptyHelper((AllocAndContextSet)other);
        }
        if (other instanceof WrappedPointsToSet) {
            return this.hasNonEmptyIntersection(((WrappedPointsToSet)other).getWrapped());
        }
        if (other instanceof PointsToSetInternal) {
            return ((PointsToSetInternal)other).forall(new P2SetVisitor(){

                @Override
                public void visit(Node n) {
                    if (!this.returnValue) {
                        for (AllocAndContext allocAndContext : AllocAndContextSet.this) {
                            if (!n.equals(allocAndContext.alloc)) continue;
                            this.returnValue = true;
                            break;
                        }
                    }
                }
            });
        }
        throw new UnsupportedOperationException("can't check intersection with set of type " + other.getClass());
    }

    private boolean nonEmptyHelper(AllocAndContextSet other) {
        for (AllocAndContext otherAllocAndContext : other) {
            for (AllocAndContext myAllocAndContext : this) {
                ImmutableStack<Integer> otherContext;
                ImmutableStack<Integer> myContext;
                if (!otherAllocAndContext.alloc.equals(myAllocAndContext.alloc) || !(myContext = myAllocAndContext.context).topMatches(otherContext = otherAllocAndContext.context) && !otherContext.topMatches(myContext)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<ClassConstant> possibleClassConstants() {
        HashSet<ClassConstant> res = new HashSet<ClassConstant>();
        for (AllocAndContext allocAndContext : this) {
            AllocNode n = allocAndContext.alloc;
            if (n instanceof ClassConstantNode) {
                res.add(((ClassConstantNode)n).getClassConstant());
                continue;
            }
            return null;
        }
        return res;
    }

    @Override
    public Set<String> possibleStringConstants() {
        HashSet<String> res = new HashSet<String>();
        for (AllocAndContext allocAndContext : this) {
            AllocNode n = allocAndContext.alloc;
            if (n instanceof StringConstantNode) {
                res.add(((StringConstantNode)n).getString());
                continue;
            }
            return null;
        }
        return res;
    }

    @Override
    public Set<Type> possibleTypes() {
        HashSet<Type> res = new HashSet<Type>();
        for (AllocAndContext allocAndContext : this) {
            res.add(allocAndContext.alloc.getType());
        }
        return res;
    }

    @Override
    public int pointsToSetHashCode() {
        int PRIME = 31;
        int result = 1;
        for (AllocAndContext elem : this) {
            result = 31 * result + elem.hashCode();
        }
        return result;
    }

    @Override
    public boolean pointsToSetEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AllocAndContextSet)) {
            return false;
        }
        AllocAndContextSet otherPts = (AllocAndContextSet)other;
        return this.superSetOf(otherPts, this) && this.superSetOf(this, otherPts);
    }

    private boolean superSetOf(AllocAndContextSet onePts, AllocAndContextSet otherPts) {
        return onePts.containsAll(otherPts);
    }
}

