/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.EquivalentValue;
import soot.SootMethod;
import soot.Value;
import soot.jimple.Constant;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Ref;
import soot.jimple.toolkits.infoflow.CachedEquivalentValue;
import soot.jimple.toolkits.infoflow.CallLocalityContext;
import soot.jimple.toolkits.infoflow.InfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.SmartMethodInfoFlowAnalysis;
import soot.toolkits.graph.UnitGraph;

public class SmartMethodLocalObjectsAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(SmartMethodLocalObjectsAnalysis.class);
    public static int counter = 0;
    static boolean printMessages;
    SootMethod method;
    InfoFlowAnalysis dfa;
    SmartMethodInfoFlowAnalysis smdfa;

    public SmartMethodLocalObjectsAnalysis(SootMethod method, InfoFlowAnalysis dfa) {
        this.method = method;
        this.dfa = dfa;
        this.smdfa = dfa.getMethodInfoFlowAnalysis(method);
        printMessages = dfa.printDebug();
        ++counter;
    }

    public SmartMethodLocalObjectsAnalysis(UnitGraph g, InfoFlowAnalysis dfa) {
        this(g.getBody().getMethod(), dfa);
    }

    public Value getThisLocal() {
        return this.smdfa.getThisLocal();
    }

    public boolean isObjectLocal(Value local, CallLocalityContext context) {
        EquivalentValue localEqVal = local instanceof InstanceFieldRef ? InfoFlowAnalysis.getNodeForFieldRef(this.method, ((FieldRef)local).getField()) : new CachedEquivalentValue(local);
        List<EquivalentValue> sources = this.smdfa.sourcesOf(localEqVal);
        for (EquivalentValue source : sources) {
            if (source.getValue() instanceof Ref) {
                if (context.isFieldLocal(source)) continue;
                if (printMessages) {
                    logger.debug("      Requested value " + local + " is SHARED in " + this.method + " ");
                }
                return false;
            }
            if (!(source.getValue() instanceof Constant)) continue;
            if (printMessages) {
                logger.debug("      Requested value " + local + " is SHARED in " + this.method + " ");
            }
            return false;
        }
        if (printMessages) {
            logger.debug("      Requested value " + local + " is LOCAL in " + this.method + " ");
        }
        return true;
    }

    public static boolean isObjectLocal(InfoFlowAnalysis dfa, SootMethod method, CallLocalityContext context, Value local) {
        SmartMethodInfoFlowAnalysis smdfa = dfa.getMethodInfoFlowAnalysis(method);
        EquivalentValue localEqVal = local instanceof InstanceFieldRef ? InfoFlowAnalysis.getNodeForFieldRef(method, ((FieldRef)local).getField()) : new CachedEquivalentValue(local);
        List<EquivalentValue> sources = smdfa.sourcesOf(localEqVal);
        for (EquivalentValue source : sources) {
            if (!(source.getValue() instanceof Ref) || context.isFieldLocal(source)) continue;
            if (printMessages) {
                logger.debug("      Requested value " + local + " is LOCAL in " + method + " ");
            }
            return false;
        }
        if (printMessages) {
            logger.debug("      Requested value " + local + " is SHARED in " + method + " ");
        }
        return true;
    }
}

