/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp.findobject;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.thread.mhp.findobject.MultiRunStatementsFinder;
import soot.jimple.toolkits.thread.mhp.pegcallgraph.PegCallGraph;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.FlowSet;

public class MultiCalledMethods {
    Set<SootMethod> multiCalledMethods = new HashSet<SootMethod>();

    MultiCalledMethods(PegCallGraph pcg, Set<SootMethod> mcm) {
        this.multiCalledMethods = mcm;
        this.byMCalledS0(pcg);
        this.finder1(pcg);
        this.finder2(pcg);
        this.propagate(pcg);
    }

    private void byMCalledS0(PegCallGraph pcg) {
        for (SootMethod sm : pcg) {
            CompleteUnitGraph graph = new CompleteUnitGraph(sm.getActiveBody());
            CallGraph callGraph = Scene.v().getCallGraph();
            MultiRunStatementsFinder finder = new MultiRunStatementsFinder(graph, sm, this.multiCalledMethods, callGraph);
            FlowSet flowSet = finder.getMultiRunStatements();
        }
    }

    private void propagate(PegCallGraph pcg) {
        HashSet<SootMethod> visited = new HashSet<SootMethod>();
        ArrayList<SootMethod> reachable = new ArrayList<SootMethod>();
        reachable.addAll(this.multiCalledMethods);
        while (reachable.size() >= 1) {
            SootMethod popped = (SootMethod)reachable.remove(0);
            if (visited.contains(popped)) continue;
            if (!this.multiCalledMethods.contains(popped)) {
                this.multiCalledMethods.add(popped);
            }
            visited.add(popped);
            for (Object succ : pcg.getSuccsOf(popped)) {
                reachable.add((SootMethod)succ);
            }
        }
    }

    private void finder1(PegCallGraph pcg) {
        Set clinitMethods = pcg.getClinitMethods();
        for (Object head : pcg) {
            HashSet gray = new HashSet();
            LinkedList queue = new LinkedList();
            queue.add(head);
            while (queue.size() > 0) {
                Object root = queue.getFirst();
                for (Object succ : pcg.getSuccsOf(root)) {
                    if (!gray.contains(succ)) {
                        gray.add(succ);
                        queue.addLast(succ);
                        continue;
                    }
                    if (clinitMethods.contains(succ)) continue;
                    this.multiCalledMethods.add((SootMethod)succ);
                }
                queue.remove(root);
            }
        }
    }

    private void finder2(PegCallGraph pcg) {
        pcg.trim();
        HashSet<SootMethod> first = new HashSet<SootMethod>();
        HashSet<SootMethod> second = new HashSet<SootMethod>();
        for (SootMethod s : pcg) {
            if (second.contains(s)) continue;
            this.visitNode(s, pcg, first, second);
        }
    }

    private void visitNode(SootMethod node, PegCallGraph pcg, Set<SootMethod> first, Set<SootMethod> second) {
        if (first.contains(node)) {
            second.add(node);
            if (!this.multiCalledMethods.contains(node)) {
                this.multiCalledMethods.add(node);
            }
        } else {
            first.add(node);
        }
        for (SootMethod succ : pcg.getTrimSuccsOf(node)) {
            if (second.contains(succ)) continue;
            this.visitNode(succ, pcg, first, second);
        }
    }

    public Set<SootMethod> getMultiCalledMethods() {
        return this.multiCalledMethods;
    }
}

