/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.ResolutionFailedException;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.validation.BodyValidator;
import soot.validation.UnitValidationException;
import soot.validation.ValidationException;

public enum FieldRefValidator implements BodyValidator
{
    INSTANCE;


    public static FieldRefValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exceptions) {
        SootMethod method = body.getMethod();
        if (method.isAbstract()) {
            return;
        }
        for (Unit unit : body.getUnits().getNonPatchingChain()) {
            SootField field;
            FieldRef v;
            Stmt s = (Stmt)unit;
            if (!s.containsFieldRef()) continue;
            FieldRef fr = s.getFieldRef();
            if (fr instanceof StaticFieldRef) {
                v = (StaticFieldRef)fr;
                try {
                    field = ((StaticFieldRef)v).getField();
                    if (field == null) {
                        exceptions.add(new UnitValidationException(unit, body, "Resolved field is null: " + fr.toString()));
                        continue;
                    }
                    if (field.isStatic() || field.isPhantom()) continue;
                    exceptions.add(new UnitValidationException(unit, body, "Trying to get a static field which is non-static: " + v));
                }
                catch (ResolutionFailedException e) {
                    exceptions.add(new UnitValidationException(unit, body, "Trying to get a static field which is non-static: " + v));
                }
                continue;
            }
            if (fr instanceof InstanceFieldRef) {
                v = (InstanceFieldRef)fr;
                try {
                    field = v.getField();
                    if (field == null) {
                        exceptions.add(new UnitValidationException(unit, body, "Resolved field is null: " + fr.toString()));
                        continue;
                    }
                    if (!field.isStatic() || field.isPhantom()) continue;
                    exceptions.add(new UnitValidationException(unit, body, "Trying to get an instance field which is static: " + v));
                }
                catch (ResolutionFailedException e) {
                    exceptions.add(new UnitValidationException(unit, body, "Trying to get an instance field which is static: " + v));
                }
                continue;
            }
            throw new AssertionError((Object)("unknown field ref: " + fr));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

