/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.Orderer;

public class PseudoTopologicalOrderer<N>
implements Orderer<N> {
    public static final boolean REVERSE = true;
    private boolean mIsReversed = false;

    public PseudoTopologicalOrderer() {
    }

    @Override
    public List<N> newList(DirectedGraph<N> g, boolean reverse) {
        this.mIsReversed = reverse;
        return new ReverseOrderBuilder<N>(g).computeOrder(!reverse);
    }

    @Deprecated
    public PseudoTopologicalOrderer(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    @Deprecated
    public List<N> newList(DirectedGraph<N> g) {
        return new ReverseOrderBuilder<N>(g).computeOrder(!this.mIsReversed);
    }

    @Deprecated
    public void setReverseOrder(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    @Deprecated
    public boolean isReverseOrder() {
        return this.mIsReversed;
    }

    private static class ReverseOrderBuilder<N> {
        private final DirectedGraph<N> graph;
        private final int graphSize;
        private final int[] indexStack;
        private final N[] stmtStack;
        private final Set<N> visited;
        private final N[] order;
        private int orderLength;

        public ReverseOrderBuilder(DirectedGraph<N> g) {
            int n;
            this.graph = g;
            this.graphSize = n = g.size();
            this.visited = Collections.newSetFromMap(new IdentityHashMap(n * 2 + 1));
            this.indexStack = new int[n];
            Object[] tempStmtStack = new Object[n];
            this.stmtStack = tempStmtStack;
            Object[] tempOrder = new Object[n];
            this.order = tempOrder;
            this.orderLength = 0;
        }

        public List<N> computeOrder(boolean reverse) {
            for (N s : this.graph) {
                if (this.visited.add(s)) {
                    this.visitNode(s);
                }
                if (this.orderLength != this.graphSize) continue;
                break;
            }
            if (reverse) {
                ReverseOrderBuilder.reverseArray(this.order);
            }
            return Arrays.asList(this.order);
        }

        private void visitNode(N startStmt) {
            int last = 0;
            this.stmtStack[last] = startStmt;
            this.indexStack[last++] = -1;
            while (last > 0) {
                int n = last - 1;
                this.indexStack[n] = this.indexStack[n] + 1;
                int toVisitIndex = this.indexStack[n];
                N toVisitNode = this.stmtStack[last - 1];
                List<N> succs = this.graph.getSuccsOf(toVisitNode);
                if (toVisitIndex >= succs.size()) {
                    this.order[this.orderLength++] = toVisitNode;
                    --last;
                    continue;
                }
                N childNode = succs.get(toVisitIndex);
                if (!this.visited.add(childNode)) continue;
                this.stmtStack[last] = childNode;
                this.indexStack[last++] = -1;
            }
        }

        private static <T> void reverseArray(T[] array) {
            int max = array.length >> 1;
            int i = 0;
            int j = array.length - 1;
            while (i < max) {
                T temp = array[i];
                array[i] = array[j];
                array[j] = temp;
                ++i;
                --j;
            }
        }
    }
}

