/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import soot.util.HashChain;

public class IterableMap<K, V>
implements Map<K, V> {
    private final HashMap<K, V> content_map;
    private final HashMap<V, HashChain<K>> back_map;
    private final HashChain<K> key_chain;
    private final HashChain<V> value_chain;
    private transient Set<K> keySet = null;
    private transient Set<V> valueSet = null;
    private transient Collection<V> values = null;

    public IterableMap() {
        this(7, 0.7f);
    }

    public IterableMap(int initialCapacity) {
        this(initialCapacity, 0.7f);
    }

    public IterableMap(int initialCapacity, float loadFactor) {
        this.content_map = new HashMap(initialCapacity, loadFactor);
        this.back_map = new HashMap(initialCapacity, loadFactor);
        this.key_chain = new HashChain();
        this.value_chain = new HashChain();
    }

    @Override
    public void clear() {
        for (Object next : this.key_chain) {
            this.content_map.remove(next);
        }
        for (Object next : this.value_chain) {
            this.back_map.remove(next);
        }
        this.key_chain.clear();
        this.value_chain.clear();
    }

    public Iterator<K> iterator() {
        return this.key_chain.iterator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.key_chain.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.value_chain.contains(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.content_map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IterableMap)) {
            return false;
        }
        IterableMap other = (IterableMap)o;
        if (!this.key_chain.equals(other.key_chain)) {
            return false;
        }
        for (K ko : this.key_chain) {
            if (other.content_map.get(ko) == this.content_map.get(ko)) continue;
            return false;
        }
        return true;
    }

    @Override
    public V get(Object key) {
        return this.content_map.get(key);
    }

    @Override
    public int hashCode() {
        return this.content_map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.key_chain.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return IterableMap.this.key_chain.iterator();
                }

                @Override
                public int size() {
                    return IterableMap.this.key_chain.size();
                }

                @Override
                public boolean contains(Object o) {
                    return IterableMap.this.key_chain.contains(o);
                }

                @Override
                public boolean remove(Object o) {
                    if (!IterableMap.this.key_chain.contains(o)) {
                        return false;
                    }
                    if (IterableMap.this.content_map.get(o) == null) {
                        IterableMap.this.remove(o);
                        return true;
                    }
                    return IterableMap.this.remove(o) != null;
                }

                @Override
                public void clear() {
                    IterableMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Set<V> valueSet() {
        if (this.valueSet == null) {
            this.valueSet = new AbstractSet<V>(){

                @Override
                public Iterator<V> iterator() {
                    return IterableMap.this.value_chain.iterator();
                }

                @Override
                public int size() {
                    return IterableMap.this.value_chain.size();
                }

                @Override
                public boolean contains(Object o) {
                    return IterableMap.this.value_chain.contains(o);
                }

                @Override
                public boolean remove(Object o) {
                    if (!IterableMap.this.value_chain.contains(o)) {
                        return false;
                    }
                    HashChain c = (HashChain)IterableMap.this.back_map.get(o);
                    Iterator it = c.snapshotIterator();
                    while (it.hasNext()) {
                        Object ko = it.next();
                        if (IterableMap.this.content_map.get(o) == null) {
                            IterableMap.this.remove(ko);
                            continue;
                        }
                        if (IterableMap.this.remove(ko) != null) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public void clear() {
                    IterableMap.this.clear();
                }
            };
        }
        return this.valueSet;
    }

    @Override
    public V put(K key, V value) {
        if (this.key_chain.contains(key)) {
            V old_value = this.content_map.get(key);
            if (old_value == value) {
                return value;
            }
            HashChain<Object> kc = this.back_map.get(old_value);
            kc.remove(key);
            if (kc.isEmpty()) {
                this.value_chain.remove(old_value);
                this.back_map.remove(old_value);
            }
            if ((kc = this.back_map.get(value)) == null) {
                kc = new HashChain();
                this.back_map.put((HashChain<K>)value, (HashChain<V>)kc);
                this.value_chain.add(value);
            }
            kc.add(key);
            return old_value;
        }
        this.key_chain.add(key);
        this.content_map.put(key, value);
        HashChain<Object> kc = this.back_map.get(value);
        if (kc == null) {
            kc = new HashChain();
            this.back_map.put((HashChain<K>)value, (HashChain<V>)kc);
            this.value_chain.add(value);
        }
        kc.add(key);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        Iterator<Object> it = t instanceof IterableMap ? ((IterableMap)t).key_chain.iterator() : t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    @Override
    public V remove(Object key) {
        if (!this.key_chain.contains(key)) {
            return null;
        }
        this.key_chain.remove(key);
        V value = this.content_map.remove(key);
        HashChain<K> c = this.back_map.get(value);
        c.remove(key);
        if (c.isEmpty()) {
            this.back_map.remove(value);
        }
        return value;
    }

    @Override
    public int size() {
        return this.key_chain.size();
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Mapping_Iterator(IterableMap.this.key_chain, IterableMap.this.content_map);
                }

                @Override
                public int size() {
                    return IterableMap.this.key_chain.size();
                }

                @Override
                public boolean contains(Object o) {
                    return IterableMap.this.value_chain.contains(o);
                }

                @Override
                public void clear() {
                    IterableMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public static class Mapping_Iterator<K, V>
    implements Iterator<V> {
        private final Iterator<K> it;
        private final HashMap<K, V> m;

        public Mapping_Iterator(HashChain<K> c, HashMap<K, V> m) {
            this.it = c.iterator();
            this.m = m;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public V next() throws NoSuchElementException {
            return this.m.get(this.it.next());
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("You cannot remove from an Iterator on the values() for an IterableMap.");
        }
    }
}

