/*
 * Decompiled with CFR 0.152.
 */
package soot.util.cfgcmd;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.toolkits.graph.ArrayRefBlockGraph;
import soot.toolkits.graph.BriefBlockGraph;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.ClassicCompleteBlockGraph;
import soot.toolkits.graph.ClassicCompleteUnitGraph;
import soot.toolkits.graph.CompleteBlockGraph;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalBlockGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.TrapUnitGraph;
import soot.toolkits.graph.ZonedBlockGraph;
import soot.util.cfgcmd.AltClassLoader;
import soot.util.cfgcmd.CFGOptionMatcher;
import soot.util.cfgcmd.CFGToDotGraph;
import soot.util.dot.DotGraph;

public abstract class CFGGraphType
extends CFGOptionMatcher.CFGOption {
    private static final Logger logger = LoggerFactory.getLogger(CFGGraphType.class);
    private static final boolean DEBUG = true;
    public static final CFGGraphType BRIEF_UNIT_GRAPH = new CFGGraphType("BriefUnitGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new BriefUnitGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType EXCEPTIONAL_UNIT_GRAPH = new CFGGraphType("ExceptionalUnitGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG((ExceptionalUnitGraph)g);
        }
    };
    public static final CFGGraphType COMPLETE_UNIT_GRAPH = new CFGGraphType("CompleteUnitGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new CompleteUnitGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG((CompleteUnitGraph)g);
        }
    };
    public static final CFGGraphType TRAP_UNIT_GRAPH = new CFGGraphType("TrapUnitGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new TrapUnitGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType CLASSIC_COMPLETE_UNIT_GRAPH = new CFGGraphType("ClassicCompleteUnitGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new ClassicCompleteUnitGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType BRIEF_BLOCK_GRAPH = new CFGGraphType("BriefBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new BriefBlockGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType EXCEPTIONAL_BLOCK_GRAPH = new CFGGraphType("ExceptionalBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new ExceptionalBlockGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG((ExceptionalBlockGraph)g);
        }
    };
    public static final CFGGraphType COMPLETE_BLOCK_GRAPH = new CFGGraphType("CompleteBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new CompleteBlockGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType CLASSIC_COMPLETE_BLOCK_GRAPH = new CFGGraphType("ClassicCompleteBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new ClassicCompleteBlockGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType ARRAY_REF_BLOCK_GRAPH = new CFGGraphType("ArrayRefBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new ArrayRefBlockGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType ZONED_BLOCK_GRAPH = new CFGGraphType("ZonedBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return new ZonedBlockGraph(b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType ALT_BRIEF_UNIT_GRAPH = new CFGGraphType("AltBriefUnitGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return CFGGraphType.loadAltGraph("soot.toolkits.graph.BriefUnitGraph", b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType ALT_COMPLETE_UNIT_GRAPH = new CFGGraphType("AltCompleteUnitGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return CFGGraphType.loadAltGraph("soot.toolkits.graph.CompleteUnitGraph", b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType ALT_TRAP_UNIT_GRAPH = new CFGGraphType("AltTrapUnitGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return CFGGraphType.loadAltGraph("soot.toolkits.graph.TrapUnitGraph", b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType ALT_ARRAY_REF_BLOCK_GRAPH = new CFGGraphType("AltArrayRefBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return CFGGraphType.loadAltGraph("soot.toolkits.graph.ArrayRefBlockGraph", b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType ALT_BRIEF_BLOCK_GRAPH = new CFGGraphType("AltBriefBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return CFGGraphType.loadAltGraph("soot.toolkits.graph.BriefBlockGraph", b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType ALT_COMPLETE_BLOCK_GRAPH = new CFGGraphType("AltCompleteBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return CFGGraphType.loadAltGraph("soot.toolkits.graph.CompleteBlockGraph", b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    public static final CFGGraphType ALT_ZONED_BLOCK_GRAPH = new CFGGraphType("AltZonedBlockGraph"){

        @Override
        public DirectedGraph<?> buildGraph(Body b) {
            return CFGGraphType.loadAltGraph("soot.toolkits.graph.ZonedBlockGraph", b);
        }

        @Override
        public DotGraph drawGraph(CFGToDotGraph drawer, DirectedGraph<?> g, Body b) {
            return drawer.drawCFG(g, b);
        }
    };
    private static final CFGOptionMatcher graphTypeOptions = new CFGOptionMatcher(new CFGGraphType[]{BRIEF_UNIT_GRAPH, EXCEPTIONAL_UNIT_GRAPH, COMPLETE_UNIT_GRAPH, TRAP_UNIT_GRAPH, CLASSIC_COMPLETE_UNIT_GRAPH, BRIEF_BLOCK_GRAPH, EXCEPTIONAL_BLOCK_GRAPH, COMPLETE_BLOCK_GRAPH, CLASSIC_COMPLETE_BLOCK_GRAPH, ARRAY_REF_BLOCK_GRAPH, ZONED_BLOCK_GRAPH, ALT_ARRAY_REF_BLOCK_GRAPH, ALT_BRIEF_UNIT_GRAPH, ALT_COMPLETE_UNIT_GRAPH, ALT_TRAP_UNIT_GRAPH, ALT_BRIEF_BLOCK_GRAPH, ALT_COMPLETE_BLOCK_GRAPH, ALT_ZONED_BLOCK_GRAPH});

    public abstract DirectedGraph<?> buildGraph(Body var1);

    public abstract DotGraph drawGraph(CFGToDotGraph var1, DirectedGraph<?> var2, Body var3);

    private CFGGraphType(String name) {
        super(name);
    }

    public static CFGGraphType getGraphType(String option) {
        return (CFGGraphType)graphTypeOptions.match(option);
    }

    public static String help(int initialIndent, int rightMargin, int hangingIndent) {
        return graphTypeOptions.help(initialIndent, rightMargin, hangingIndent);
    }

    private static DirectedGraph<?> loadAltGraph(String className, Body b) {
        try {
            Class<?> graphClass = AltClassLoader.v().loadClass(className);
            Constructor<?> constructor = graphClass.getConstructor(Body.class);
            DirectedGraph result = (DirectedGraph)constructor.newInstance(b);
            return result;
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), e);
            throw new IllegalArgumentException("Unable to find " + className + " in alternate classpath: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), e);
            throw new IllegalArgumentException("There is no " + className + "(Body) constructor: " + e.getMessage());
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), e);
            throw new IllegalArgumentException("Unable to instantiate " + className + " in alternate classpath: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), e);
            throw new IllegalArgumentException("Unable to access " + className + "(Body) in alternate classpath: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage(), e);
            throw new IllegalArgumentException("Unable to invoke " + className + "(Body) in alternate classpath: " + e.getMessage());
        }
    }
}

