/********************************************************************************
 * Copyright (c) 2022 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ********************************************************************************/
/**
 * Used to determine the version of current process.
 */
public class GetJavaVersion16 {
    public static void main(String[] args) {
        String version = System.getProperty("java.version");
        int majorVersion = -1;
        try {
            if (version != null) {
                String[] s = version.split("\\.");
                if ("1".equals(s[0]) && s.length >= 2) {
                    majorVersion = Integer.parseInt(s[1]);
                } else {
                    majorVersion = Integer.parseInt(s[0]);
                }
            }
        } catch (Exception e) {
            //silent ignore.
        }
        if (majorVersion != -1) {
            System.out.println("[" + majorVersion + "]");
        }
    }
}