/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common;

import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emt4j.common.ClassSymbol;
import org.eclipse.emt4j.common.DependTarget;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.SourceInformation;

public class Dependency
implements Serializable,
Cloneable {
    private String locationExternalForm;
    private DependTarget target;
    private String targetFilePath;
    private transient Class callerClass;
    private String callerMethod;
    private transient Class[] nonJdkCallerClass;
    private StackTraceElement[] stacktrace;
    private transient Map<String, Object> context;
    private transient byte[] currClassBytecode;
    private transient ClassSymbol classSymbol;
    private SourceInformation sourceInformation;
    private List<Integer> lines;

    public Dependency(URL location, DependTarget target, StackTraceElement[] stacktrace, String targetFilePath) {
        this.target = target;
        this.stacktrace = stacktrace;
        if (location != null) {
            this.locationExternalForm = location.toExternalForm();
        }
        this.targetFilePath = targetFilePath;
    }

    public Dependency() {
    }

    public DependType getDependType() {
        return this.target.type;
    }

    public DependTarget getTarget() {
        return this.target;
    }

    public String getLocationExternalForm() {
        return this.locationExternalForm;
    }

    public void setTarget(DependTarget target) {
        this.target = target;
    }

    public Class[] getNonJdkCallerClass() {
        return this.nonJdkCallerClass;
    }

    public void setNonJdkCallerClass(Class[] nonJdkCallerClass) {
        this.nonJdkCallerClass = nonJdkCallerClass;
    }

    public StackTraceElement[] getStacktrace() {
        return this.stacktrace;
    }

    public void setStacktrace(StackTraceElement[] stacktrace) {
        this.stacktrace = stacktrace;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public Dependency clone() {
        Dependency cloned = new Dependency();
        cloned.target = this.target;
        cloned.nonJdkCallerClass = this.nonJdkCallerClass;
        cloned.stacktrace = this.stacktrace;
        cloned.context = this.context;
        cloned.callerClass = this.callerClass;
        cloned.callerMethod = this.callerMethod;
        cloned.locationExternalForm = this.locationExternalForm;
        cloned.targetFilePath = this.targetFilePath;
        cloned.sourceInformation = this.sourceInformation;
        cloned.lines = this.lines;
        return cloned;
    }

    public Class getCallerClass() {
        return this.callerClass;
    }

    public void setCallerClass(Class callerClass) {
        this.callerClass = callerClass;
    }

    public String getCallerMethod() {
        return this.callerMethod;
    }

    public void setCallerMethod(String callerMethod) {
        this.callerMethod = callerMethod;
    }

    public byte[] getCurrClassBytecode() {
        return this.currClassBytecode;
    }

    public void setCurrClassBytecode(byte[] currClassBytecode) {
        this.currClassBytecode = currClassBytecode;
    }

    public ClassSymbol getClassSymbol() {
        return this.classSymbol;
    }

    public void setClassSymbol(ClassSymbol classSymbol) {
        this.classSymbol = classSymbol;
    }

    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public void setTargetFilePath(String targetFilePath) {
        this.targetFilePath = targetFilePath;
    }

    public SourceInformation getSourceInformation() {
        return this.sourceInformation;
    }

    public void setSourceInformation(SourceInformation sourceInformation) {
        this.sourceInformation = sourceInformation;
    }

    public List<Integer> getLines() {
        return this.lines;
    }

    public void setLines(List<Integer> lines) {
        this.lines = lines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.locationExternalForm, that.locationExternalForm) && Objects.equals(this.target, that.target) && Objects.equals(this.targetFilePath, that.targetFilePath) && Objects.equals(this.callerClass, that.callerClass) && Objects.equals(this.callerMethod, that.callerMethod) && Arrays.equals(this.nonJdkCallerClass, that.nonJdkCallerClass) && Arrays.equals(this.stacktrace, that.stacktrace) && Objects.equals(this.context, that.context) && Arrays.equals(this.currClassBytecode, that.currClassBytecode) && Objects.equals(this.classSymbol, that.classSymbol) && Objects.equals(this.sourceInformation, that.sourceInformation) && Objects.equals(this.lines, that.lines);
    }

    public int hashCode() {
        int result = Objects.hash(this.locationExternalForm, this.target, this.targetFilePath, this.callerClass, this.callerMethod, this.context, this.classSymbol, this.sourceInformation, this.lines);
        result = 31 * result + Arrays.hashCode(this.nonJdkCallerClass);
        result = 31 * result + Arrays.hashCode(this.stacktrace);
        result = 31 * result + Arrays.hashCode(this.currClassBytecode);
        return result;
    }

    public String toString() {
        return "Dependency{locationExternalForm='" + this.locationExternalForm + '\'' + ", target=" + this.target + ", targetFilePath='" + this.targetFilePath + '\'' + ", callerClass=" + this.callerClass + ", callerMethod='" + this.callerMethod + '\'' + ", nonJdkCallerClass=" + Arrays.toString(this.nonJdkCallerClass) + ", stacktrace=" + Arrays.toString(this.stacktrace) + ", context=" + this.context + ", currClassBytecode=" + Arrays.toString(this.currClassBytecode) + ", classSymbol=" + this.classSymbol + ", sourceInformation=" + this.sourceInformation + ", lines=" + this.lines + '}';
    }
}

