/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import org.eclipse.emt4j.common.JdkMigrationException;
import org.eclipse.emt4j.common.i18n.I18nResourceUnit;

public class ReportResourceAccessor {
    private final Locale locale;
    private Map<String, Optional<ResourceBundle>> resourceBundleMap = new HashMap<String, Optional<ResourceBundle>>();
    private ResourceBundle commonResource;

    public ReportResourceAccessor(Locale locale) {
        this.locale = locale;
    }

    public I18nResourceUnit getResourceUnit(String resultCode, String subResultCode, String i18nBase) {
        ResourceBundle resultCodeSpecific = this.getResourceBundleLazily(resultCode, subResultCode, i18nBase);
        I18nResourceUnit resourceUnit = new I18nResourceUnit(resultCode, subResultCode, this, i18nBase);
        resourceUnit.setDescription(resultCodeSpecific.getString("description"));
        resourceUnit.setTitle(resultCodeSpecific.getString("title"));
        resourceUnit.setSolution(resultCodeSpecific.getString("solution"));
        ResourceBundle common = this.getCommonResourceBundle(i18nBase);
        resourceUnit.setDescriptionTitle(common.getString("description.title"));
        resourceUnit.setSolutionTitle(common.getString("solution.title"));
        resourceUnit.setIssueContextTitle(common.getString("issue.context.title"));
        return resourceUnit;
    }

    public String getNoIssueResource(String i18nBase) {
        return this.getCommonResourceBundle(i18nBase).getString("no.issue");
    }

    public String getString(String i18nBase, String key) {
        return this.getCommonResourceBundle(i18nBase).getString(key);
    }

    public String getCheckResultForFeature(String i18nBase) {
        return this.getCommonResourceBundle(i18nBase).getString("result.for.feature");
    }

    public ResourceBundle getCommonResourceBundle(String i18nBase) {
        if (null == this.commonResource) {
            this.commonResource = this.selectResourceBundle("common", i18nBase);
        }
        return this.commonResource;
    }

    public boolean containResourceBundle(String resultCode, String subResultCode, String i18nBase) {
        String key = resultCode + "_" + subResultCode;
        Optional<ResourceBundle> value = this.resourceBundleMap.get(key);
        if (value != null) {
            return value.isPresent();
        }
        try {
            ResourceBundle resourceBundle = this.selectResourceBundle(key, i18nBase);
            this.resourceBundleMap.put(key, Optional.of(resourceBundle));
            return true;
        }
        catch (MissingResourceException mre) {
            this.resourceBundleMap.put(key, Optional.empty());
            return false;
        }
    }

    private ResourceBundle selectResourceBundle(String baseName, String i18nBase) {
        return ResourceBundle.getBundle(i18nBase + baseName, this.locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
    }

    private ResourceBundle getResourceBundleLazily(String resultCode, String subResultCode, String i18nBase) {
        String[] keys;
        for (String key : keys = this.getPriorityKeys(resultCode, subResultCode)) {
            Optional<ResourceBundle> value = this.resourceBundleMap.get(key);
            if (value != null && value.isPresent()) {
                return value.get();
            }
            try {
                ResourceBundle resourceBundle = this.selectResourceBundle(key, i18nBase);
                this.resourceBundleMap.put(key, Optional.of(resourceBundle));
                return resourceBundle;
            }
            catch (MissingResourceException mre) {
                this.resourceBundleMap.put(key, Optional.empty());
            }
        }
        throw new JdkMigrationException("Can not found resource bundle for result code=" + resultCode + ",sub result code=" + subResultCode + ",i18nBase=" + i18nBase);
    }

    private String[] getPriorityKeys(String resultCode, String subResultCode) {
        if (null == subResultCode || "".equals(subResultCode)) {
            return new String[]{resultCode};
        }
        return new String[]{resultCode + "_" + subResultCode, resultCode};
    }
}

