/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.JdkMigrationException;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.rule.model.JarFileInfo;
import org.eclipse.emt4j.common.rule.model.JarFileName;
import org.eclipse.emt4j.common.rule.model.JarRule;
import org.eclipse.emt4j.common.rule.model.Version;
import org.eclipse.emt4j.common.util.FileUtil;
import org.eclipse.emt4j.common.util.JarFileInfoUtil;
import org.mvel2.MVEL;

@RuleImpl(type="incompatible-jar")
public class IncompatibleJarRule
extends ExecutableRule {
    private String jarRuleFile;
    private Map<String, JarRule> sortArtifactToJarRule = new HashMap<String, JarRule>();

    public IncompatibleJarRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public CheckResult check(Dependency dependency) {
        Optional<JarFileInfo> jarFileInfo = JarFileInfoUtil.match(dependency.getTarget().asLocation().getLocationExternalForm());
        if (jarFileInfo.isPresent()) {
            JarRule jarRule = this.sortArtifactToJarRule.get(this.key(jarFileInfo.get().getOrderedArtifactFragments()));
            if (null == jarRule) {
                return CheckResult.PASS;
            }
            HashMap<String, Object> mvelMap = new HashMap<String, Object>();
            mvelMap.put("$version", new Version(jarFileInfo.get().getVersion()));
            mvelMap.put("$jar", new JarFileName(jarFileInfo.get().getJarFileName()));
            Object result = MVEL.eval((String)jarRule.getRule(), mvelMap);
            if (result instanceof Boolean) {
                if (((Boolean)result).booleanValue()) {
                    return CheckResult.PASS;
                }
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("jar", dependency.getTarget().asLocation().getLocationExternalForm());
                context.put("rule", this.moreReadable(jarRule.getRule()));
                context.put("artifact", jarRule.getArtifact().toUpperCase());
                return CheckResult.fail(context);
            }
            throw new JdkMigrationException("MVEL expression not return boolean for artifact:" + jarRule.getArtifact() + ",rule:" + jarRule.getRule());
        }
        return CheckResult.PASS;
    }

    private String moreReadable(String rule) {
        return rule.replaceAll("\\$version", "Version should ").replaceAll("\\$jar", "Jar name should ").replaceAll(".ge", ">=").replaceAll(".lt", "<").replaceAll(".le", "<=").replaceAll(".eq", "==").replaceAll(".ne", "!=").replaceAll(".gt", ">=").replaceAll(".contains", "include").replace('(', ' ').replace(')', ' ');
    }

    @Override
    public void init() {
        FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.jarRuleFile, false).forEach(l -> {
            String[] artifactRule = l.split(",");
            String[] artifacts = this.stripDoubleQuote(artifactRule[0]).split("\\|");
            String rule = this.stripDoubleQuote(artifactRule[1]);
            for (String artifact : artifacts) {
                this.sortArtifactToJarRule.put(this.key(JarFileInfoUtil.sortArtifactFragments(artifact)), new JarRule(artifact, rule));
            }
        });
    }

    private String stripDoubleQuote(String str) {
        return str.substring(str.indexOf(34) + 1, str.lastIndexOf(34));
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.CODE_SOURCE == dependency.getDependType();
    }

    public String getJarRuleFile() {
        return this.jarRuleFile;
    }

    public void setJarRuleFile(String jarRuleFile) {
        this.jarRuleFile = jarRuleFile;
    }

    private String key(String[] sortArtifactFragments) {
        return String.join((CharSequence)"-", sortArtifactFragments);
    }
}

