/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.MethodDesc;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.util.FileUtil;

@RuleImpl(type="touched-method")
public class TouchedMethodRule
extends ExecutableRule {
    private String methodListFile;
    protected List<MethodDesc> callMethods;

    public String getMethodListFile() {
        return this.methodListFile;
    }

    public void setMethodListFile(String methodListFile) {
        this.methodListFile = methodListFile;
    }

    public TouchedMethodRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        List<String> lines = FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.methodListFile, false);
        this.callMethods = new ArrayList<MethodDesc>(lines.size());
        for (String line : lines) {
            String className = line.substring(0, line.indexOf(46));
            String methodName = line.substring(line.indexOf(46) + 1, line.indexOf(40));
            String desc = line.substring(line.indexOf(40));
            this.callMethods.add(new MethodDesc(className, className.replace('/', '.'), methodName, desc));
        }
    }

    @Override
    public CheckResult check(Dependency dependency) {
        return this.callMethods.stream().noneMatch(m -> m.getMethodIdentifierNoDesc().equals(dependency.getTarget().asMethod().toMethodIdentifierNoDesc())) ? CheckResult.PASS : CheckResult.FAIL;
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.METHOD == dependency.getDependType();
    }
}

